* ----------------- Structural Tables ------------------------------------

$ontext


$offtext


*------- 2. Load Sets Used in this Module --------------------------------

SETS

* Sets for structural tables

 stab1       real and nominal macroeconomic summary totals
 stab2       imports or exports
 stab3       commodity account structure
 stab4       activity account structure
 stab5       factor use structure
 stab6       tax structure

  ;

$GDXIN data_in.gdx

$LOAD stab1 stab2 stab3 stab4 stab5 stab6

$GDXIN

*------- 1. Define Structural Tables -------------------------------------

* This section defines the structural tables that are used to report
* descriptive statistics for the database used for this model

PARAMETERS

* --- Macroeconomic Tables ---

*Macroeconomic tables - indexed on stab1

 bMACROTOT(stab1,r)      Base Macroeconomic totals
 bMACROSH1(stab1,r)      Base Macroeconomic shares in GDP Expenditure
 bMACROSH2(stab1,r)      Base Macroeconomic shares in Domestic Absorption

* --- Commodity Tables ---

* - Trade shares - indexed on stab2

 bIMPORTST(stab2,w,c,r)   Base Import shares in c from w by reg
 bIMPORTST2(stab2,w,r)    Base Import shares of total imports from w by reg
 bEXPORTST(stab2,c,w,r)   Base Export shares in c to w by reg
 bEXPORTST2(stab2,w,r)    Base Export shares of total exports to w by reg

* - Commodity account shares - indexed on stab3

 bCOMMODST(stab3,c,r)     Base Commodity shares in c by reg

* --- Activity Tables ---

 bACTIVST(stab4,a,r)      Base Activity shares in a by reg

* --- Factor Tables ---

 bFACTUSEST(stab5,f,a,r)  Base factor use by activities and region


  ;

* ------- 2. Assign Structural Tables ------------------------------------

* --- Macroeconomic Tables ---

* Value of household consumption
 bMACROTOT("stQCDTOT",r)
            = SUM((c,h),PQCD.L(c,r) * QCD.L(c,h,r)) ;

* Value of government consumption
 bMACROTOT("stQGDTOT",r)
            = SUM(c,PQD.L(c,r) * QGD.L(c,r)) ;

* Value of investment consumption
 bMACROTOT("stQINVTOT",r)
            = SUM(c,PQD.L(c,r) * QINVD.L(c,r)) ;

* Value of Domestic final demand
 bMACROTOT("stABSORP",r)
            = SUM((c,h),PQCD.L(c,r) * QCD.L(c,h,r))
              + SUM(c,PQD.L(c,r) * QGD.L(c,r))
              + SUM(c,PQD.L(c,r) * QINVD.L(c,r)) ;

* Value of import demand
 bMACROTOT("stIMPORT",r)
            = SUM(c,PM.L(c,r) * QM.L(c,r)) ;

* Value of export supply
 bMACROTOT("stEXPORT",r)
            = SUM(c,PE.L(c,r) * QE.L(c,r)) ;

* GDP from Expenditure side - C + I + G + E - M
 bMACROTOT("stGDP",r)
            = SUM((c,h),PQCD.L(c,r) * QCD.L(c,h,r))
                + SUM(c,PQD.L(c,r) * QGD.L(c,r))
                + SUM(c,PQD.L(c,r) * QINVD.L(c,r))
                + SUM((c,w), PWE.L(c,w,r) * QER.L(c,w,r) * ER.L(r))
                - SUM((c,w), PWM.L(w,c,r) * QMR.L(w,c,r) * ER.L(r)) ;

* total domestic production
 bMACROTOT("stSUPPLY",r)
            = SUM(c,PXC.L(c,r)* QXC.L(c,r)) ;

* total intermediate inputs
 bMACROTOT("stUSE",r)
            = SUM(c,PQD.L(c,r)* QINTD.L(c,r)) ;

* household income
 bMACROTOT("stYHTOT",r)
            = SUM(h,YH.L(h,r)) ;

* government income
 bMACROTOT("stYGTOT",r)      = YG.L(r) ;

* factor income
 bMACROTOT("stYFTOT",r)      = SUM(f,YF.L(f,r)) ;

* distributed factor income
 bMACROTOT("stYFDISTTOT",r)  = SUM(f,YFDIST.L(f,r)) ;

* Labour income
 bMACROTOT("stYFLABTOT",r)   = SUM(l,YF.L(l,r)) ;

* total savings
 bMACROTOT("stTOTSAV",r)     = TOTSAV.L(r) ;

* household savings
 bMACROTOT("stHOSAV",r)
            = SUM(h,YH.L(h,r) * (1-TYH.L(h,r))
                 * SHH.L(h,r)) ;

* government savings
 bMACROTOT("stKAPGOV",r)     = KAPGOV.L(r) ;

* foreign savings
 bMACROTOT("stKAPWOR",r)       = (KAPWOR.L(r)*ER.L(r)) ;

* Depreciation
 bMACROTOT("stDPREC",r)     = SUM(f,deprec(f,r)*YF.L(f,r)) ;

* Import tariff revenue
 bMACROTOT("stMTAX",r)       = MTAX.L(r) ;

* Export tax revenue
 bMACROTOT("stETAX",r)       = ETAX.L(r) ;

* Sales tax revenue
 bMACROTOT("stSTAX",r)       = STAX.L(r) ;

* Value added tax revenue
 bMACROTOT("stVTAX",r)       = VTAX.L(r) ;

* Indirect tax revenue
 bMACROTOT("stITAX",r)       = ITAX.L(r) ;

* Factor tax revenu
 bMACROTOT("stFTAX",r)       = FTAX.L(r) ;

* Household income tax revenue
 bMACROTOT("stHTAX",r)       = HTAX.L(r) ;

* --- Macroeconomic Shares ---

* Share of household consumption in GDPEXP
 bMACROSH1("stQCDTOT",r)$bMACROTOT("stGDP",r)
                         = SUM((c,h),PQCD.L(c,r) * QCD.L(c,h,r))
                                /bMACROTOT("stGDP",r) ;

* Share of government consumption in GDPEXP
 bMACROSH1("stQGDTOT",r)$bMACROTOT("stGDP",r)
            = SUM(c,PQD.L(c,r) * QGD.L(c,r))
                                /bMACROTOT("stGDP",r) ;

* Share of investment consumption in GDPEXP
 bMACROSH1("stQINVTOT",r)$bMACROTOT("stGDP",r)
            = SUM(c,PQD.L(c,r) * QINVD.L(c,r))
                                /bMACROTOT("stGDP",r) ;

* Ratio of import demand to GDPEXP
 bMACROSH1("stIMPORT",r)$bMACROTOT("stGDP",r)
            = SUM(c,PM.L(c,r) * QM.L(c,r))
                                /bMACROTOT("stGDP",r) ;

* Ratio of export supply to GDPEXP
 bMACROSH1("stEXPORT",r)$bMACROTOT("stGDP",r)
            = SUM(c,PE.L(c,r) * QE.L(c,r))
                                /bMACROTOT("stGDP",r) ;

* Share of household consumption in ABSORP
 bMACROSH2("stQCDTOT",r)$bMACROTOT("stABSORP",r)
            = SUM((c,h),PQCD.L(c,r) * QCD.L(c,h,r))
                                /bMACROTOT("stABSORP",r) ;

* Share of government consumption in ABSORP
 bMACROSH2("stQGDTOT",r)$bMACROTOT("stABSORP",r)
            = SUM(c,PQD.L(c,r) * QGD.L(c,r))
                                /bMACROTOT("stABSORP",r) ;

* Share of investment consumption in ABSORP
 bMACROSH2("stQINVTOT",r)$bMACROTOT("stABSORP",r)
            = SUM(c,PQD.L(c,r) * QINVD.L(c,r))
                                /bMACROTOT("stABSORP",r) ;

* Ration of import demand consumption to ABSORP
 bMACROSH2("stIMPORT",r)$bMACROTOT("stABSORP",r)
            = SUM(c,PM.L(c,r) * QM.L(c,r))
                                /bMACROTOT("stABSORP",r) ;

* Ratio of export supply to ABSORP
 bMACROSH2("stEXPORT",r)$bMACROTOT("stABSORP",r)
            = SUM(c,PE.L(c,r) * QE.L(c,r))
                                /bMACROTOT("stABSORP",r) ;

* --- Commodity Tables ---

* --- Trade shares - indexed on stab2

 bIMPORTST("stIMPregFOB",w,c,r)$SUM(wp,PWMFOB.L(wp,c,r)* QMR.L(wp,c,r))
          = (PWMFOB.L(w,c,r)* QMR.L(w,c,r))
              /SUM(wp,PWMFOB.L(wp,c,r)* QMR.L(wp,c,r)) ;

 bIMPORTST2("stIMPregtotFOB",w,r)$SUM((c,wp),PWMFOB.L(wp,c,r)* QMR.L(wp,c,r))
          = (SUM(c, PWMFOB.L(w,c,r)* QMR.L(w,c,r)))
              /SUM((c,wp),PWMFOB.L(wp,c,r)* QMR.L(wp,c,r)) ;

 bIMPORTST("stIMPcomFOB",w,c,r)$SUM(cp,PWMFOB.L(w,cp,r)* QMR.L(w,cp,r))
          = (PWMFOB.L(w,c,r)* QMR.L(w,c,r))
              /SUM(cp,PWMFOB.L(w,cp,r)* QMR.L(w,cp,r)) ;

 bIMPORTST("stSmImpSh",w,c,r)$(bIMPORTST("stIMPcomFOB",w,c,r) LT 0.001)
          = bIMPORTST("stIMPcomFOB",w,c,r) ;

 bIMPORTST("stIMPregCIF",w,c,r)$SUM(wp,PWM.L(wp,c,r)* QMR.L(wp,c,r))
          = (PWM.L(w,c,r)* QMR.L(w,c,r))
              /SUM(wp,PWM.L(wp,c,r)* QMR.L(wp,c,r)) ;

 bIMPORTST("stIMPcomCIF",w,c,r)$SUM(cp,PWM.L(w,cp,r)* QMR.L(w,cp,r))
          = (PWM.L(w,c,r)* QMR.L(w,c,r))
              /SUM(cp,PWM.L(w,cp,r)* QMR.L(w,cp,r)) ;

 bIMPORTST("stIMPregDOM",w,c,r)$SUM(wp,PMR.L(wp,c,r)* QMR.L(wp,c,r))
          = (PMR.L(w,c,r)* QMR.L(w,c,r))
              /SUM(wp,PMR.L(wp,c,r)* QMR.L(wp,c,r)) ;

 bIMPORTST("stIMPcomDOM",w,c,r)$SUM(cp,PMR.L(w,cp,r)* QMR.L(w,cp,r))
          = (PMR.L(w,c,r)* QMR.L(w,c,r))
              /SUM(cp,PMR.L(w,cp,r)* QMR.L(w,cp,r)) ;


 bEXPORTST("stEXPregFOB",c,w,r)$SUM(wp,PWE.L(c,wp,r)* QER.L(c,wp,r))
          = (PWE.L(c,w,r)* QER.L(c,w,r))
              /SUM(wp,PWE.L(c,wp,r)* QER.L(c,wp,r)) ;

 bEXPORTST2("stEXPregtotFOB",w,r)$SUM((c,wp),PWE.L(c,wp,r)* QER.L(c,wp,r))
          = (SUM(c,PWE.L(c,w,r)* QER.L(c,w,r)))
              /SUM((c,wp),PWE.L(c,wp,r)* QER.L(c,wp,r)) ;

 bEXPORTST("stEXPcomFOB",c,w,r)$SUM(cp,PWE.L(cp,w,r)* QER.L(cp,w,r))
          = (PWE.L(c,w,r)* QER.L(c,w,r))
              /SUM(cp,PWE.L(cp,w,r)* QER.L(cp,w,r)) ;

 bEXPORTST("stSmExpSh",c,w,r)$(bEXPORTST("stEXPcomFOB",c,w,r) LT 0.001)
          = bEXPORTST("stEXPcomFOB",c,w,r) ;

 bEXPORTST("stEXPregDOM",c,w,r)$SUM(wp,PER.L(c,wp,r)* QER.L(c,wp,r))
          = (PER.L(c,w,r)* QER.L(c,w,r))
              /SUM(wp,PER.L(c,wp,r)* QER.L(c,wp,r)) ;

 bEXPORTST("stEXPcomDOM",c,w,r)$SUM(cp,PER.L(cp,w,r)* QER.L(cp,w,r))
          = (PER.L(c,w,r)* QER.L(c,w,r))
              /SUM(cp,PER.L(cp,w,r)* QER.L(cp,w,r)) ;
Parameter
 stIMPcomCNT
 stSmImpCNT
 stEXPcomCNT
 stSmExpCNT
  ;

 stIMPcomCNT = SUM((wgn,c,rgn)$bIMPORTST("stIMPcomFOB",wgn,c,rgn), 1) ;

 stSmImpCNT  = SUM((w,c,r)$bIMPORTST("stSmImpSh",w,c,r), 1) ;

 stEXPcomCNT = SUM((c,wgn,rgn)$bEXPORTST("stEXPcomFOB",c,wgn,rgn), 1) ;

 stSmExpCNT  = SUM((c,w,r)$bEXPORTST("stSmExpSh",c,w,r), 1) ;

* --- Commodity account shares - indexed on stab3

* Demand Structures

 bCOMMODST("stPRIVregDEM",c,r)$(PQCD.L(c,r)*SUM(h,QCD.L(c,h,r))
                               + PQD.L(c,r)*(QGD.L(c,r)
                                          + QINVD.L(c,r) + QINTD.L(c,r)))
           = SUM(h,(PQCD.L(c,r)* QCD.L(c,h,r)))
               /(PQCD.L(c,r)*SUM(h,QCD.L(c,h,r))
                               + PQD.L(c,r)*(QGD.L(c,r)
                                          + QINVD.L(c,r) + QINTD.L(c,r))) ;

 bCOMMODST("stPRIVcomDEM",c,r)$SUM((cp,h),PQCD.L(cp,r)* QCD.L(cp,h,r))
           = SUM(h,(PQCD.L(c,r)* QCD.L(c,h,r)))
               /SUM((cp,h),PQCD.L(cp,r)* QCD.L(cp,h,r)) ;

 bCOMMODST("stGOVTregDEM",c,r)$(PQCD.L(c,r)*SUM(h,QCD.L(c,h,r))
                               + PQD.L(c,r)*(QGD.L(c,r)
                                          + QINVD.L(c,r) + QINTD.L(c,r)))
           = (PQD.L(c,r)* QGD.L(c,r))
               /(PQCD.L(c,r)*SUM(h,QCD.L(c,h,r))
                               + PQD.L(c,r)*(QGD.L(c,r)
                                          + QINVD.L(c,r) + QINTD.L(c,r))) ;

 bCOMMODST("stGOVTcomDEM",c,r)$SUM(cp,PQD.L(cp,r)* QGD.L(cp,r))
           = (PQD.L(c,r)* QGD.L(c,r))
               /SUM(cp,PQD.L(cp,r)* QGD.L(cp,r)) ;

 bCOMMODST("stINVDregDEM",c,r)$(PQCD.L(c,r)*SUM(h,QCD.L(c,h,r))
                               + PQD.L(c,r)*(QGD.L(c,r)
                                          + QINVD.L(c,r) + QINTD.L(c,r)))
           = (PQD.L(c,r)* QINVD.L(c,r))
               /(PQCD.L(c,r)*SUM(h,QCD.L(c,h,r))
                               + PQD.L(c,r)*(QGD.L(c,r)
                                          + QINVD.L(c,r) + QINTD.L(c,r)))  ;

 bCOMMODST("stINVDcomDEM",c,r)$SUM(cp,PQD.L(cp,r)* QINVD.L(cp,r))
           = (PQD.L(c,r)* QINVD.L(c,r))
               /SUM(cp,PQD.L(cp,r)* QINVD.L(cp,r)) ;

 bCOMMODST("stINTDregDEM",c,r)$(PQCD.L(c,r)*SUM(h,QCD.L(c,h,r))
                               + PQD.L(c,r)*(QGD.L(c,r)
                                          + QINVD.L(c,r) + QINTD.L(c,r)))
           = (PQD.L(c,r)* QINTD.L(c,r))
               /(PQCD.L(c,r)*SUM(h,QCD.L(c,h,r))
                               + PQD.L(c,r)*(QGD.L(c,r)
                                          + QINVD.L(c,r) + QINTD.L(c,r))) ;

 bCOMMODST("stINTDcomDEM",c,r)$SUM(cp,PQD.L(cp,r)* QINTD.L(cp,r))
           = (PQD.L(c,r)* QINTD.L(c,r))
               /SUM(cp,PQD.L(cp,r)* QINTD.L(cp,r)) ;

* Supply Structures

 bCOMMODST("stMAKEcomSUP",c,r)$SUM(cp,PXC.L(cp,r)* QXC.L(cp,r))
           = (PXC.L(c,r)* QXC.L(c,r))
              /SUM(cp,PXC.L(cp,r)* QXC.L(cp,r)) ;

 bCOMMODST("stQMcomSUP",c,r)$SUM(cp,PM.L(cp,r)* QM.L(cp,r))
           = (PM.L(c,r)* QM.L(c,r))
              /SUM(cp,PM.L(cp,r)* QM.L(cp,r)) ;

 bCOMMODST("stQDcomSUP",c,r)$SUM(cp,PD.L(cp,r)* QD.L(cp,r))
           = (PD.L(c,r)* QD.L(c,r))
              /SUM(cp,PD.L(cp,r)* QD.L(cp,r)) ;

 bCOMMODST("stSUPPcomSUP",c,r)$SUM(cp,(PD.L(cp,r)* QD.L(cp,r))
                                      + (PM.L(c,r)* QM.L(c,r)))
           = ((PD.L(c,r)* QD.L(c,r))+(PM.L(c,r)* QM.L(c,r)))
               /SUM(cp,(PD.L(cp,r)* QD.L(cp,r))
                 + (PM.L(c,r)* QM.L(c,r))) ;

 bCOMMODST("stQEconSUP",c,r)$SUM(cp,PE.L(cp,r)* QE.L(cp,r))
           = (PE.L(c,r)* QE.L(c,r))
               /SUM(cp,PE.L(cp,r)* QE.L(cp,r)) ;

* --- Activity Tables ---

 bACTIVST("stQINTQX",a,r)$(SUM(ap,PX.L(ap,r)*QX.L(ap,r)))
                    = (PINT.L(a,r)*QINT.L(a,r))/SUM(ap,PX.L(ap,r)*QX.L(ap,r)) ;

 bACTIVST("stQINT",a,r)$(SUM(ap,PINT.L(ap,r)*QINT.L(ap,r)))
                    = (PINT.L(a,r)*QINT.L(a,r))/SUM(ap,PINT.L(ap,r)*QINT.L(ap,r)) ;

 bACTIVST("stVAQX",a,r)$(SUM(ap,PX.L(ap,r)*QX.L(ap,r)))
                    = (PVA.L(a,r)*QVA.L(a,r))/SUM(ap,PX.L(ap,r)*QX.L(ap,r)) ;

 bACTIVST("stVA",a,r)$(SUM(ap,PVA.L(ap,r)*QVA.L(ap,r)))
                    = (PVA.L(a,r)*QVA.L(a,r))/SUM(ap,PVA.L(ap,r)*QVA.L(ap,r)) ;

 bACTIVST("stQX",a,r)$(SUM(ap,PX.L(ap,r)*QX.L(ap,r)))
                     = (PX.L(a,r)*QX.L(a,r))/SUM(ap,PX.L(ap,r)*QX.L(ap,r)) ;

 bACTIVST("stLAB",a,r)$(PVA.L(a,r)*QVA.L(a,r))
                     = (SUM(l,WF.L(l,r)*WFDIST.L(l,a,r)*FD.L(l,a,r)))
                           /(PVA.L(a,r)*QVA.L(a,r)) ;

 bACTIVST("stUskLAB",a,r)$(PVA.L(a,r)*QVA.L(a,r))
                     = (SUM(lu,WF.L(lu,r)*WFDIST.L(lu,a,r)*FD.L(lu,a,r)))
                           /(PVA.L(a,r)*QVA.L(a,r)) ;

 bACTIVST("stSkLAB",a,r)$(PVA.L(a,r)*QVA.L(a,r))
                     = (SUM(ls,WF.L(ls,r)*WFDIST.L(ls,a,r)*FD.L(ls,a,r)))
                           /(PVA.L(a,r)*QVA.L(a,r)) ;

 bACTIVST("stCAP",a,r)$(PVA.L(a,r)*QVA.L(a,r))
                     = (SUM(k,WF.L(k,r)*WFDIST.L(k,a,r)*FD.L(k,a,r)))
                           /(PVA.L(a,r)*QVA.L(a,r)) ;

 bACTIVST("stLND",a,r)$(PVA.L(a,r)*QVA.L(a,r))
                     = (SUM(lnd,WF.L(lnd,r)*WFDIST.L(lnd,a,r)*FD.L(lnd,a,r)))
                           /(PVA.L(a,r)*QVA.L(a,r)) ;

 bACTIVST("stFTAX",a,r)$(PVA.L(a,r)*QVA.L(a,r))
              = (SUM(f,TF.L(f,a,r)*WF.L(f,r)*WFDIST.L(f,a,r)*FD.L(f,a,r)))
                          /(PVA.L(a,r)*QVA.L(a,r)) ;

 bACTIVST("stFACTchk",a,r)
                     = bACTIVST("stUskLAB",a,r) + bACTIVST("stSkLAB",a,r)
                       + bACTIVST("stCAP",a,r) + bACTIVST("stLND",a,r)
                       + bACTIVST("stFTAX",a,r) ;

 bACTIVST("stSUB",a,r)$aqx(a,r) = 1 ;

 bACTIVST("stELASTX",a,r)$aqx(a,r) = ELASTX(a,r) ;

 bACTIVST("stELASTVA",a,r)$aqx(a,r) = ELASTVA(a,r) ;

* --- Factor Tables ---

* Assigning factor tables

 bFACTUSEST("stTRANS",f,a,r)
                     = (WF.L(f,r) * WFDIST.L(f,a,r) * FD.L(f,a,r)) ;

 bFACTUSEST("stACTSH",f,a,r)$(SUM(fp,bFACTUSEST("stTRANS",fp,a,r)))
                     = bFACTUSEST("stTRANS",f,a,r)
                          /(SUM(fp,bFACTUSEST("stTRANS",fp,a,r))) ;

 bFACTUSEST("stFFSH",f,a,r)$(SUM(ap,bFACTUSEST("stTRANS",f,ap,r)))
                     = bFACTUSEST("stTRANS",f,a,r)
                          /(SUM(ap,bFACTUSEST("stTRANS",f,ap,r))) ;


* ------- Exporting Structural Tables to GDX -----------------------------

* This writes the results data to GDX

Execute_Unload  '6_results/anar_t_struct.gdx',

bMACROTOT,
bMACROSH1,
bMACROSH2,

bIMPORTST,
bIMPORTST2,
bEXPORTST,
bEXPORTST2,

bCOMMODST,

bACTIVST,

bFACTUSEST


   ;


* ----------------- END OF Structural Tables -----------------------------
