* -------------- anar_t data entry and model conditioning file ----------
$ontext
 This file:
    a) controls the sets and data that are read into the model
    b) conditions a range of sets etc., that determine certain
       characterisitics of the model.

 To implement the actions controlled by this file the user needs to generate:
    1) An Excel workbook that contains
       Layout sheet
       Sets sheet

          An example is provided as ???.xls

    2) An GDX file that contains
       A global SAM
       Values for those elasticities provided by GTAP

          An example is provided as ???.gdx

 This file is laid out as follows:

*#### 1. DATA  ENTRY SECTION ########
    *---- 1a. Excel workbook sets and data converted to gdx here
          In the statement
          $CALL "GDXXRW i=[filename].xls o=data_in.gdx INDEX=LAYOUT!A4"
          the user replaces [filename] with the Excel filename
    *---- 1b. All data, elasticities and sets from excel are assigned here
          There should be no need to make changes here unless the model
          is being changed.
    *---- 1c. All GTAP transactions and elasticity data are assigned here
          In the statement
          $GDXIN [filename].gdx
          the user replaces [filename] with the GDX data filename
    *---- 1d. Controlling for elasticity data for GLO region
    *---- 1e. Defining SETS by exclusions from previously defined SETS

*#### 2. REMOVING VERY SMALL VALUES FROM SAMG ########
    This section eliminates all transaction below the value of
    mod_cont("mintrans"), which is set in the Excel workbook,
     This is implemented on the base data, i.e., before scaling, and the
    value should typically be less than 0.0001.
          The truncated data are checked and the SAMG passed to the next
          stage unloaded as 'samgmod.gdx'.

*#### 3. AUTOMATIC SCALING OF VALUES IN SAMG ########
    This section uses mod_cont("scalprop") and mod_cont("scaltarg") that
    are set in the Excel workbook to control automatic scaling.
     The default values of mod_cont("scalprop") and mod_cont("scaltarg")
    are 0.95 and 100.

*#### 4. ASSIGNING FINAL MODEL TRANSACTION AND FACTOR USE DATA ########
    *---- 4a. Scaling transactions data
          This uses samscal from section 3.
    *---- 4b. Assigning and scaling factor use data
          This uses the assigned SAMG values as the default. Alternative
          data can be used if they are known.
    *---- 4c. Checking the data used in the model
          The model data are checked and the SAMG used in the model is
          unloaded as 'samgmod.gdx'.

*#### 5. ASSIGNING SETS TO CONTROL MODEL STRUCTURE ########
    *---- 5a. Defining sets to control production nesting structure
          This uses the data and the sets aleon and rleon from the
          worksheet 'mod_sets' to set aqx and aqxn. A manual option is
          also available. aqxn is the complement to aqx.
    *---- 5b. Defining sets to control homogenous exports
          This uses the data and the sets chomo1, chomo2, rhomo1 and rhomo2
          from the worksheet 'mod_sets' to set cetn1 and cetn2. A manual
          option is also available.

$offtext

*#### 1. DATA  ENTRY SECTION ########

*---- 1a. Excel workbook sets and data converted to gdx here

* Convert Excel workbook data to GDX here

$CALL "GDXXRW i=1_1_Model_data/%mod_xls_data%.xlsx o=1_1_Model_data/data_in.gdx INDEX=LAYOUT!A4 trace=3"
$if errorLevel 1 $abort problems with GDXXRW

*---- 1b. All data, elasticities and sets from excel are assigned here

$GDXIN 1_1_Model_data/data_in.GDX

* LOAD sets
$LOADdc sac
$LOADdc c cagr cnat cfd cind cuti cser cagg
$LOADdc a aagr anat afd aind auti aser aagg
$LOADdc ff f fag l ls lu k lnd
$LOADdc tmr ter tff h g i owatpmarg w
$LOADdc r ref
$LOADdc ragg wagg

$LOADdc aleon rleon

* LOAD maps
$LOADdc map_w_tmr map_w_ter map_c_w_marg map_r_w map_w_r map_f_tff
$LOADdc map_tmr_w map_ter_w map_tff_f map_marg_w
$LOADdc map_ragg_r map_wagg_w

$LOADdc map_va_ff map_fagg_ff

* Load unemployment rates
*$LOADdc un_rate

* LOAD control parameters
$LOADdc mcons fcons

* Values for controlling parameters
$LOADdc flow_cont mod_cont

* loading ALL elasticities from Excel
$LOADdc elastm elastrm
$LOADdc elaste elastre
$LOADdc elastx elastva elastfd
$LOADdc elastf elasty

$GDXIN

*---- 1c. All GTAP transactions and elasticity data are assigned here
$ontext
 Read in GTAP data and elasticities from GDX file. Data are read for
 all regions as SAMG. In SAMG(*,*,*), the third index refers to the
 country SAM however, in the model, parameters, variables, and eqn. that
 describe bilateral trade, the second index refers to the country and the
 third index refers to the trade partner.
$offtext

$GDXIN 1_1_Model_data/%mod__gdx_data%.gdx

* LOAD transactions/SAMG data

$LOADdc SAMG = NEWSAM

* Loading GTAP elasticities
$LOADdc elastmg  = esubd2 elastvag = esubva2 elastrmg = esubm2

$GDXIN

*---- 1d. Singleton Sets
$onText

$offtext

$INCLUDE 1_1_Model_Data\anar_t_single.inc

*---- 1d. Controlling for elasticity data for GLO region

* Control for non presence of GLOBE in GTAP elastcities

 ELASTRMG(c,"glo")  = 1.5 ;
 ELASTMG(c,"glo")   = 1.5 ;
 ELASTVAG(a,"glo")  = 1.5 ;

* Set Frisch and Income Elasticity for Globe to ZERO in all cases

 ELASTF("glo",h)   = 0.0 ;
 ELASTY(c,h,"glo") = 0.0 ;

*---- 1e. Defining SETS by exclusions from previously defined SETS

* SAMG Accounts excluding totals
 SACN(SAC)          = YES ;
 SACN("TOTAL")      = NO  ;
 
* Rest of World accounts less Globe
 wgn(w)             = YES ;
 wgn("wglo")        = NO ;

* Region accounts less Globe
 rgn(r)             = YES ;
 rgn("glo")         = NO ;

*---- 1f. Defining MAPPING SETS by using subset information

* Mapping from commodities to aggregate commodities
 map_cagg_c("cagr",c)$(cagr(c))     = YES ;
 map_cagg_c("cnat",c)$(cnat(c))     = YES ;
 map_cagg_c("cfd",c)$(cfd(c))       = YES ;
 map_cagg_c("cind",c)$(cind(c))     = YES ;
 map_cagg_c("cuti",c)$(cuti(c))     = YES ;
 map_cagg_c("cser",c)$(cser(c))     = YES ;

* Mapping from activies to aggregate activities
 map_aagg_a("aagr",a)$(aagr(a))     = YES ;
 map_aagg_a("anat",a)$(anat(a))     = YES ;
 map_aagg_a("afd",a)$(afd(a))       = YES ;
 map_aagg_a("aind",a)$(aind(a))     = YES ;
 map_aagg_a("auti",a)$(auti(a))     = YES ;
 map_aagg_a("aser",a)$(aser(a))     = YES ;

*#### 2. REMOVING VERY SMALL VALUES FROM SAMG ########

parameter
 cutoff                minimum value for transactions in unscaled SAMG
 samgbase(sac,sac,r)   base SAMG
 samgdiff(sac,sac,r)   transactions less than cutoff in SAMG
 ;

 cutoff = mod_cont("mintrans") ;

 samgbase(sac,sacp,r) = samg(sac,sacp,r);
 SAMGdiff(sac,sacp,r)$(ABS(SAMGBASE(sac,sacp,r)) LT 0.0001)
                      = SAMGBASE(sac,sacp,r) ;

display samgdiff ;

 samg(sac,sacp,r) = samgbase(sac,sacp,r) - samgdiff(sac,sacp,r) ;

PARAMETER
 SAMGCHK(sac,r)    Check on row and column totals for unscaled SAMG ;

 SAMG("total",sacnp,r) = SUM(sacn,SAMG(sacn,sacnp,r)) ;
 SAMG(sacn,"total",r)  = SUM(sacnp,SAMG(sacn,sacnp,r)) ;

 SAMGCHK(sacn,r)       = SAMG("total",sacn,r) - SAMG(sacn,"total",r)  ;

*#### 3. AUTOMATIC SCALING OF VALUES IN SAMG ########

$ontext
AUTOMATIC CALCULATING OF A SCALING FACTOR - samscal

This instruction works by successively increasing the samscal parameter as
multiples of 10 WHILE a given proportion - mod_cont("scalprop") - of the
SAM entries are below a given target - mod_cont("scaltarg").

The conditional statement is computed as follows
Denominator - the total number of non zero cells in the SAMG(sacn,sacnp,r)
Numerator - the total number of cells in SAMG(sacn,sacnp,r) that are
            i)  non zero cells; AND
            ii) whose absolute values when divided by the current value of
                samscal are less that the target.

The ABORT statement protects against illegal values of samautoscaltarg

$offtext

* Assigning values to initialise scaling parameter

 samscal            = mod_cont("samscal") ;

ABORT $(mod_cont("scaltarg") LE 0.0)
 "mod_cont(scaltarg) is less than or equal to ZERO - set to positive value" ;

WHILE(
 ((SUM((sacn,sacnp,r)$(SAMG(sacn,sacnp,r)
                AND (ABS(SAMG(sacn,sacnp,r)/samscal) < mod_cont("scaltarg"))),1))
        /SUM((sacn,sacnp,r)$SAMG(sacn,sacnp,r), 1))
                           < mod_cont("scalprop") ,

*     samscal is increased in multiples of 10 until the condition is satisfied
      samscal = samscal * 10 ;
  ) ;

*#### 4. ASSIGNING FINAL MODEL TRANSACTION AND FACTOR USE DATA ########

*---- 4a. Scaling transactions data

 SAMG(sac,sacp,r)  = SAMG(sac,sacp,r)/samscal ;

*---- 4b. Assigning and scaling factor use data

 FACTUSE(f,a,r)    = SAMG(f,a,r) ;

*---- 4c. Checking the data used in the model

* Recalculating Account TOTALS

PARAMETER SAMGCHK2(sac,r) ;

 SAMG("total",sacnp,r) = SUM(sacn,SAMG(sacn,sacnp,r)) ;
 SAMG(sacn,"total",r)  = SUM(sacnp,SAMG(sacn,sacnp,r)) ;

 SAMGCHK2(sacn,r)      = SAMG("total",sacn,r) - SAMG(sacn,"total",r) ;

 SAMGCHK2(sacn,r)$(ABS(SAMGCHK2(sacn,r) lt (10*mod_cont("toldiffsam"))))
                        = 0.0 ;

*#### 5. ASSIGNING SETS TO CONTROL MODEL STRUCTURE ########

*---- 5a. Defining sets to control production nesting structure

$ontext
The set aqxn(a,r) - activities/regions with Leontief at the top level
is set as the complement to aqx(a,r)

Selecting aqx
 a) All activities WITH intermediate inputs where intermediates account
    for more than the value share set in Excel wsheet 'mod_controls'
    are assigned to aqx.
 b) Selected specific combinations of a and r in aqx are cancelled -
    the sets aleon and rleon allow this when cases are members of BOTH
    subsets.
 c) Other specific combinations of a and r in aqx are cancelled manually.

Setting aqxn
    Defined as the complement to aqx.

$offtext

* Top level CES chosen by reference to intermediate input shares

* aqx(a,r)$(SUM(c,SAMG(c,a,r)))      = YES ;

 aqx(a,rgn)$((SUM(c,SAMG(c,a,rgn))
               /SAMG("total",a,rgn)) GT mod_cont("minaqxsh") )
                        = YES ;

* Top level CES canceled for selected activities by sets alean and rleon

 aqx(aleon,rleon)       = NO ;

* Top level CES canceled for selected activities manually

* aqx("amines","bwa")       = NO ;

* Top level Leontief set for all activities without top level CES

 aqxn(a,r)              = not aqx(a,r) ;

*#### 6. OTHER ASSIGNMENTS FOR MODEL ########

*---- 6a. Assigning value to numeraire check parameter

 numerchk           = mod_cont("numerchk") ;


* ---------- END OF anar_t data entry and model conditioning file --------
