* ----------------- Macros For Results --------------------------------

* ------- 2. Macros used in anar_anal.inc -----------------------------

$onText
 NOTES ON CONVENTIONS USED FOR THESE MACROS

   m_    first characters 
   N     Nominals
   R     Reals
   V     Values - price times quantity
   T     Values summed over indices
   B     Base values - base price times base quantity
   _**   Defines variable by reference to quantity measure
$offtext

$ondotl

* Household Private Consumption at PURCHASER Prices

$macro m_NT_QCD   SUM[(c,h),lev_PQCD(c,r,%res_dimen%) * lev_QCD(c,h,r,%res_dimen%)]
$macro m_RT_QCD   SUM[(c,h),PQCD0(c,r) * lev_QCD(c,h,r,%res_dimen%)]
$macro m_BT_QCD   SUM[(c,h),PQCD0(c,r) * QCD0(c,h,r)]

$macro m_V_QCD    lev_PQCD(c,r,%res_dimen%) * lev_QCD(c,h,r,%res_dimen%)
$macro m_V_QCD0   PQCD0(c,r) * QCD0(c,h,r)

* Government Consumption at PURCHASER Prices

$macro m_NT_QGD   SUM[c,lev_PQD(c,r,%res_dimen%) * lev_QGD(c,r,%res_dimen%)]
$macro m_RT_QGD   SUM[c,PQD0(c,r) * lev_QGD(c,r,%res_dimen%)]                        
$macro m_BT_QGD   SUM[c,PQD0(c,r) * QGD0(c,r)]

* Investment Consumption at PURCHASER Prices

$macro m_NT_QINVD   SUM[c,lev_PQD(c,r,%res_dimen%) * lev_QINVD(c,r,%res_dimen%)]
$macro m_RT_QINVD   SUM[c,PQD0(c,r) * lev_QINVD(c,r,%res_dimen%)]                          
$macro m_BT_QINVD   SUM[c,PQD0(c,r) * QINVD0(c,r)]

* Measures of Import Expenditures at BASIC Prices

$macro m_NT_QM   SUM[c,lev_PM(c,r,%res_dimen%) * lev_QM(c,r,%res_dimen%)]
$macro m_RT_QM   SUM[c,PM0(c,r) * lev_QM(c,r,%res_dimen%)]                          
$macro m_BT_QM   SUM[c,PM0(c,r) * QM0(c,r)]

* Measures of Import Expenditures at WORLD Prices

$macro m_NT_QWM   SUM[(w,c),lev_PWM(w,c,r,%res_dimen%) * lev_ER(r,%res_dimen%) * lev_QMR(w,c,r,%res_dimen%)]
$macro m_RT_QWM   SUM[(w,c),PWM0(w,c,r) * ER0(r) * lev_QMR(w,c,r,%res_dimen%)]                          
$macro m_BT_QWM   SUM[(w,c),PWM0(w,c,r) * ER0(r) * QMR0(w,c,r)]

* Measures of Export Incomes at BASIC Prices

$macro m_NT_QE   SUM[c,lev_PE(c,r,%res_dimen%) * lev_QE(c,r,%res_dimen%)]
$macro m_RT_QE   SUM[c,PE0(c,r) * lev_QE(c,r,%res_dimen%)]                          
$macro m_BT_QE   SUM[c,PE0(c,r) * QE0(c,r)]

* Measures of Export Incomes at WORLD Prices

$macro m_NT_QWE   SUM[(c,w),lev_PWE(c,w,r,%res_dimen%) * lev_ER(r,%res_dimen%) * lev_QER(c,w,r,%res_dimen%)]
$macro m_RT_QWE   SUM[(c,w),PWE0(c,w,r) * ER0(r) * lev_QER(c,w,r,%res_dimen%)]                          
$macro m_BT_QWE   SUM[(c,w),PWE0(c,w,r) * ER0(r) * QER0(c,w,r)]

* Measures of Domestic Supply at BASIC prices

$macro m_NT_QXC   SUM[c,lev_PXC(c,r,%res_dimen%) * lev_QXC(c,r,%res_dimen%)]
$macro m_RT_QXC   SUM[c,PXC0(c,r) * lev_QXC(c,r,%res_dimen%)]                          
$macro m_BT_QXC   SUM[c,PXC0(c,r) * QXC0(c,r)]

* Measures of Intermediate Input use at PURCHASER prices

$macro m_NT_QINTD   SUM[c,lev_PQD(c,r,%res_dimen%) * lev_QINTD(c,r,%res_dimen%)]
$macro m_RT_QINTD   SUM[c,PQD0(c,r) * lev_QINTD(c,r,%res_dimen%)]                          
$macro m_BT_QINTD   SUM[c,PQD0(c,r) * QINTD0(c,r)]

* Measures of Domestic Factor Income

$macro m_NT_YF   SUM[(f,a),lev_WF(f,r,%res_dimen%) * lev_WFDIST(f,a,r,%res_dimen%) * lev_FD(f,a,r,%res_dimen%)]
$macro m_RT_YF   SUM[(f,a),WF0(f,r) * WFDIST0(f,a,r) * lev_FD(f,a,r,%res_dimen%)]                          
$macro m_BT_YF   SUM[(f,a),WF0(f,r) * WFDIST0(f,a,r) * FD0(f,a,r)]

* Measures of Domestic Labour Income

$macro m_NT_YLAB   SUM[(l,a),lev_WF(l,r,%res_dimen%) * lev_WFDIST(l,a,r,%res_dimen%) * lev_FD(l,a,r,%res_dimen%)]
$macro m_RT_YLAB   SUM[(l,a),WF0(l,r) * WFDIST0(l,a,r) * lev_FD(l,a,r,%res_dimen%)]                          
$macro m_BT_YLAB   SUM[(l,a),WF0(l,r) * WFDIST0(l,a,r) * FD0(l,a,r)]
                             
* Measures of Household Income

$macro m_NT_YH     SUM[h,lev_YH(h,r,%res_dimen%)]
$macro m_RT_YH     SUM[h,lev_YH(h,r,%res_dimen%)*CPI0(r)]
$macro m_BT_YH     SUM[h,YH0(h,r) * CPI0(r)]
                                                            
* Measures of Government Income

$macro m_NT_YG     lev_YG(r,%res_dimen%)
$macro m_RT_YG     lev_YG(r,%res_dimen%)*CPI0(r)
$macro m_BT_YG     (YG0(r) * CPI0(r))

* Measures of Depreciation

$macro m_NT_DPREC    SUM(f,deprec(f,r)*lev_YF(f,r,%res_dimen%))
$macro m_RT_DPREC    [SUM(f,deprec(f,r)*lev_YF(f,r,%res_dimen%)) * CPI0(r)]
$macro m_BT_DPREC    [SUM(f,deprec(f,r)*YF0(f,r)) * CPI0(r)]

*$macro m_NT_DPREC    SUM[f,lev_DEPRSAV(f,r,%res_dimen%)]
*$macro m_RT_DPREC    SUM[fp,lev_DEPRSAV(fp,r,%res_dimen%)*CPI0(r)]
*$macro m_BT_DPREC    SUM[f,DEPRSAV0(f,r) * CPI0(r)]
                                                              
* Measures of Total Savings

$macro m_NT_TOTSAV    lev_TOTSAV(r,%res_dimen%)
$macro m_RT_TOTSAV    lev_TOTSAV(r,%res_dimen%)*CPI0(r)
$macro m_BT_TOTSAV    [TOTSAV0(r) * CPI0(r)]
                                                               
* Measures of Internal Balance

$macro m_NT_KAPGOV     lev_KAPGOV(r,%res_dimen%)
$macro m_RT_KAPGOV     lev_KAPGOV(r,%res_dimen%)*CPI0(r)
$macro m_BT_KAPGOV     [YG0(r) * CPI0(r)]
                                                               
* Measures of External Balance

$macro m_NT_KAPWOR     lev_KAPWOR(r,%res_dimen%)*lev_ER(r,%res_dimen%)
$macro m_RT_KAPWOR     lev_KAPWOR(r,%res_dimen%)*ER0(r)
$macro m_BT_KAPWOR     [KAPWOR0(r) * ER0(r)]


   

* ----------------- end of Macros for Results -----------------------------
