*############ anar_t DECLARE AND ASSIGN SINGLETON SETS #########

*~~~~ Declare SINGLETON SETS
$ontext

  "A singleton set in GAMS is a special set that has at most one element
(zero elements are allowed as well). Like other sets, singleton sets may
have a domain with several dimensions" (GAMS Help)

  A major advantage of singleton is that they can be used WITHOUT the need
"to be controlled by a controlling index or an indexed operator like
other sets"

  ALL singleton sets in this model are declared as subsets of the sets in
the SAM (sac AND r): this ensures full domain checking.

  They are used in this model to
 1.  remove quoted elements from the code - this means that the labels in the
     SAM do NOT have to be exactly those in the code, although if not the
     assignments to each singleton set MUST be correctly assigned.
       This model uses singleton sets for the following groups
       a.  tax accounts
       b.  the government account
       c.  Rest of the World
       c.  totals

$offtext


SINGLETON SET

*~~~~~ SINGLETON SETS based on sac and r
*~~ GLOBE REGION

 g_glb(r)        GLOBE Region
 w_glb(w)        GLOBE Region as trade partner

*~~ Account Totals
 t_tot(sac)      Account totals
 
*~~ Household account

 h_h(sac)         Household account

*~~ Tax Accounts

 t_TS(sac)        Sales tax rate
 t_TV(sac)        Value added tax rate
 t_TX(sac)        Indirect tax rate
 t_TD(sac)        Direct tax rate on factor income and households

*~~ Government account
 g_t(sac)        Government account
 g_aid(sac)

*~~ Savings Investment account
 i_is(sac)       Savings Investment account

*~~ Rest of the World account
 r_w(sac)        Rest of the World account

*~~ Account Totals
 t_tot(sac)      Account totals

*~~~~~ SINGLETON SETS based on ghg

  ;

*~~~~ Assign SINGLETON SETS

*~~~~~ GLOBE REGION
 g_glb("glo")     = YES ;
 w_glb("wglo")    = YES ;

*~~~~~ Account Totals
 t_tot("total")   = YES ;
 
* Household account

 h_h("hous")      = YES ;

* Tax Accounts

 t_TS("saltax")   = YES ;
 t_TV("vattax")   = YES ;
 t_TX("prodtax")  = YES ;
 t_TD("dirtax")   = YES ;

* Government account
 g_t("govt")      = YES ;

* Savings Investment account
 i_is("i_s")      = YES ;

* Rest of the World account
* r_w(sac)        Rest of the World account

*############ END OF anar_t DECLARE AND ASSIGN SINGLETON SETS #########