* -------------- anar_t data diagnostics --------------------------------

 PARAMETERS

* Macro SAM for checking calibration and initial solve
* ASAM1 and ASAM2 are used for consistency checks

 ASAMG0(ss,ss,r)      Aggregate SAM for data entry check
 ASAMG1(ss,ss,r)      Aggregate SAM for calibration check
 ASAMG2(ss,ss,r)      Aggregate SAM for base run check

 MAXTV(r)             Maximum absolute value of transactions in SAMG
 MINTV(r)             Minimum absolute value of transactions in SAMG

   ;

* Maximum and minimum Transaction Values

 MAXTV(r)      = SMAX((sac,sacp),ABS (SAMG(sac,sacp,r))) ;
 MINTV(r)      = SMIN((sac,sacp)$SAMG(sac,sacp,r),ABS (SAMG(sac,sacp,r))) ;

 option decimals = 6 ;

DISPLAY MAXTV, MINTV ;

 option decimals = 3 ;

*#### Macro SAM to check data entry

 ASAMG0("COMMDTY","COMMDTY",r)   = SUM((c,cp),SAMG(c,cp,r)) ;
 ASAMG0("COMMDTY","ACTIVITY",r)  = SUM((c,a),SAMG(c,a,r)) ;
 ASAMG0("COMMDTY","VALUAD",r)    = SUM((c,f),SAMG(c,f,r)) ;
 ASAMG0("COMMDTY","HHOLDS",r)    = SUM((c,h),SAMG(c,h,r)) ;
 ASAMG0("COMMDTY","TMTAX",r)     = SUM((c,tmr),SAMG(c,tmr,r)) ;
 ASAMG0("COMMDTY","TETAX",r)     = SUM((c,ter),SAMG(c,ter,r)) ;
 ASAMG0("COMMDTY","TFTAX",r)     = SUM((c,tff),SAMG(c,tff,r)) ;
 ASAMG0("COMMDTY","GOVTN",r)     = SUM((c,g),SAMG(c,g,r)) ;
 ASAMG0("COMMDTY","KAPITAL",r)   = SUM((c,i),SAMG(c,i,r)) ;
 ASAMG0("COMMDTY","MARGS",r)     = SUM((c,owatpmarg),SAMG(c,owatpmarg,r)) ;
 ASAMG0("COMMDTY","WORLD",r)     = SUM((c,w),SAMG(c,w,r)) ;

 ASAMG0("ACTIVITY","COMMDTY",r)  = SUM((a,c),SAMG(a,c,r)) ;
 ASAMG0("ACTIVITY","ACTIVITY",r) = SUM((a,ap),SAMG(a,ap,r)) ;
 ASAMG0("ACTIVITY","VALUAD",r)   = SUM((a,f),SAMG(a,f,r)) ;
 ASAMG0("ACTIVITY","HHOLDS",r)   = SUM((a,h),SAMG(a,h,r)) ;
 ASAMG0("ACTIVITY","TMTAX",r)    = SUM((a,tmr),SAMG(a,tmr,r)) ;
 ASAMG0("ACTIVITY","TETAX",r)    = SUM((a,ter),SAMG(a,ter,r)) ;
 ASAMG0("ACTIVITY","TFTAX",r)    = SUM((a,tff),SAMG(a,tff,r)) ;
 ASAMG0("ACTIVITY","GOVTN",r)    = SUM((a,g),SAMG(a,g,r)) ;
 ASAMG0("ACTIVITY","KAPITAL",r)  = SUM((a,i),SAMG(a,i,r)) ;
 ASAMG0("ACTIVITY","MARGS",r)    = SUM((a,owatpmarg),SAMG(a,owatpmarg,r)) ;
 ASAMG0("ACTIVITY","WORLD",r)    = SUM((a,w),SAMG(a,w,r)) ;

 ASAMG0("VALUAD","COMMDTY",r)    = SUM((f,c),SAMG(f,c,r)) ;
 ASAMG0("VALUAD","ACTIVITY",r)   = SUM((f,a),SAMG(f,a,r)) ;
 ASAMG0("VALUAD","VALUAD",r)     = SUM((f,fp),SAMG(f,fp,r)) ;
 ASAMG0("VALUAD","HHOLDS",r)     = SUM((f,h),SAMG(f,h,r)) ;
 ASAMG0("VALUAD","TMTAX",r)      = SUM((f,tmr),SAMG(f,tmr,r)) ;
 ASAMG0("VALUAD","TETAX",r)      = SUM((f,ter),SAMG(f,ter,r)) ;
 ASAMG0("VALUAD","TFTAX",r)      = SUM((f,tff),SAMG(f,tff,r)) ;
 ASAMG0("VALUAD","GOVTN",r)      = SUM((f,g),SAMG(f,g,r)) ;
 ASAMG0("VALUAD","KAPITAL",r)    = SUM((f,i),SAMG(f,i,r)) ;
 ASAMG0("VALUAD","MARGS",r)      = SUM((f,owatpmarg),SAMG(f,owatpmarg,r)) ;
 ASAMG0("VALUAD","WORLD",r)      = SUM((f,w),SAMG(f,w,r)) ;

 ASAMG0("HHOLDS","COMMDTY",r)    = SUM((h,c),SAMG(h,c,r)) ;
 ASAMG0("HHOLDS","ACTIVITY",r)   = SUM((h,a),SAMG(h,a,r)) ;
 ASAMG0("HHOLDS","VALUAD",r)     = SUM((h,f),SAMG(h,f,r)) ;
 ASAMG0("HHOLDS","HHOLDS",r)     = SUM((h,hp),SAMG(h,hp,r)) ;
 ASAMG0("HHOLDS","TMTAX",r)      = SUM((h,tmr),SAMG(h,tmr,r)) ;
 ASAMG0("HHOLDS","TETAX",r)      = SUM((h,ter),SAMG(h,ter,r)) ;
 ASAMG0("HHOLDS","TFTAX",r)      = SUM((h,tff),SAMG(h,tff,r)) ;
 ASAMG0("HHOLDS","GOVTN",r)      = SUM((h,g),SAMG(h,g,r)) ;
 ASAMG0("HHOLDS","KAPITAL",r)    = SUM((h,i),SAMG(h,i,r)) ;
 ASAMG0("HHOLDS","MARGS",r)      = SUM((h,owatpmarg),SAMG(h,owatpmarg,r)) ;
 ASAMG0("HHOLDS","WORLD",r)      = SUM((h,w),SAMG(h,w,r)) ;

 ASAMG0("TMTAX","COMMDTY",r)    = SUM((tmr,c),SAMG(tmr,c,r)) ;
 ASAMG0("TMTAX","ACTIVITY",r)   = SUM((tmr,a),SAMG(tmr,a,r)) ;
 ASAMG0("TMTAX","VALUAD",r)     = SUM((tmr,f),SAMG(tmr,f,r)) ;
 ASAMG0("TMTAX","HHOLDS",r)     = SUM((tmr,h),SAMG(tmr,h,r)) ;
 ASAMG0("TMTAX","TMTAX",r)      = SUM((tmr,tmrp),SAMG(tmr,tmrp,r)) ;
 ASAMG0("TMTAX","TETAX",r)      = SUM((tmr,ter),SAMG(tmr,ter,r)) ;
 ASAMG0("TMTAX","TFTAX",r)      = SUM((tmr,tff),SAMG(tmr,tff,r)) ;
 ASAMG0("TMTAX","GOVTN",r)      = SUM((tmr,g),SAMG(tmr,g,r)) ;
 ASAMG0("TMTAX","KAPITAL",r)    = SUM((tmr,i),SAMG(tmr,i,r)) ;
 ASAMG0("TMTAX","MARGS",r)      = SUM((tmr,owatpmarg),SAMG(tmr,owatpmarg,r)) ;
 ASAMG0("TMTAX","WORLD",r)      = SUM((tmr,w),SAMG(tmr,w,r)) ;

 ASAMG0("TETAX","COMMDTY",r)    = SUM((ter,c),SAMG(ter,c,r)) ;
 ASAMG0("TETAX","ACTIVITY",r)   = SUM((ter,a),SAMG(ter,a,r)) ;
 ASAMG0("TETAX","VALUAD",r)     = SUM((ter,f),SAMG(ter,f,r)) ;
 ASAMG0("TETAX","HHOLDS",r)     = SUM((ter,h),SAMG(ter,h,r)) ;
 ASAMG0("TETAX","TMTAX",r)      = SUM((ter,tmr),SAMG(ter,tmr,r)) ;
 ASAMG0("TETAX","TETAX",r)      = SUM((ter,terp),SAMG(ter,terp,r)) ;
 ASAMG0("TETAX","TFTAX",r)      = SUM((ter,tff),SAMG(ter,tff,r)) ;
 ASAMG0("TETAX","GOVTN",r)      = SUM((ter,g),SAMG(ter,g,r)) ;
 ASAMG0("TETAX","KAPITAL",r)    = SUM((ter,i),SAMG(ter,i,r)) ;
 ASAMG0("TETAX","MARGS",r)      = SUM((ter,owatpmarg),SAMG(ter,owatpmarg,r)) ;
 ASAMG0("TETAX","WORLD",r)      = SUM((ter,w),SAMG(ter,w,r)) ;

 ASAMG0("TFTAX","COMMDTY",r)    = SUM((tff,c),SAMG(tff,c,r)) ;
 ASAMG0("TFTAX","ACTIVITY",r)   = SUM((tff,a),SAMG(tff,a,r)) ;
 ASAMG0("TFTAX","VALUAD",r)     = SUM((tff,f),SAMG(tff,f,r)) ;
 ASAMG0("TFTAX","HHOLDS",r)     = SUM((tff,h),SAMG(tff,h,r)) ;
 ASAMG0("TFTAX","TMTAX",r)      = SUM((tff,tmr),SAMG(tff,tmr,r)) ;
 ASAMG0("TFTAX","TETAX",r)      = SUM((tff,ter),SAMG(tff,ter,r)) ;
 ASAMG0("TFTAX","TFTAX",r)      = SUM((tff,tffp),SAMG(tff,tffp,r)) ;
 ASAMG0("TFTAX","GOVTN",r)      = SUM((tff,g),SAMG(tff,g,r)) ;
 ASAMG0("TFTAX","KAPITAL",r)    = SUM((tff,i),SAMG(tff,i,r)) ;
 ASAMG0("TFTAX","MARGS",r)      = SUM((tff,owatpmarg),SAMG(tff,owatpmarg,r)) ;
 ASAMG0("TFTAX","WORLD",r)      = SUM((tff,w),SAMG(tff,w,r)) ;

 ASAMG0("GOVTN","COMMDTY",r)     = SUM((g,c),SAMG(g,c,r)) ;
 ASAMG0("GOVTN","ACTIVITY",r)    = SUM((g,a),SAMG(g,a,r)) ;
 ASAMG0("GOVTN","VALUAD",r)      = SUM((g,f),SAMG(g,f,r)) ;
 ASAMG0("GOVTN","HHOLDS",r)      = SUM((g,h),SAMG(g,h,r)) ;
 ASAMG0("GOVTN","TMTAX",r)       = SUM((g,tmr),SAMG(g,tmr,r)) ;
 ASAMG0("GOVTN","TETAX",r)       = SUM((g,ter),SAMG(g,ter,r)) ;
 ASAMG0("GOVTN","TFTAX",r)       = SUM((g,tff),SAMG(g,tff,r)) ;
* ASAMG0("GOVTN","GOVTN",r)       = SUM((g,gp),SAMG(g,gp,r)) ;
 ASAMG0("GOVTN","KAPITAL",r)     = SUM((g,i),SAMG(g,i,r)) ;
 ASAMG0("GOVTN","MARGS",r)       = SUM((g,owatpmarg),SAMG(g,owatpmarg,r)) ;
 ASAMG0("GOVTN","WORLD",r)       = SUM((g,w),SAMG(g,w,r)) ;

 ASAMG0("KAPITAL","COMMDTY",r)   = SUM((i,c),SAMG(i,c,r)) ;
 ASAMG0("KAPITAL","ACTIVITY",r)  = SUM((i,a),SAMG(i,a,r)) ;
 ASAMG0("KAPITAL","VALUAD",r)    = SUM((i,f),SAMG(i,f,r)) ;
 ASAMG0("KAPITAL","HHOLDS",r)    = SUM((i,h),SAMG(i,h,r)) ;
 ASAMG0("KAPITAL","TMTAX",r)     = SUM((i,tmr),SAMG(i,tmr,r)) ;
 ASAMG0("KAPITAL","TETAX",r)     = SUM((i,ter),SAMG(i,ter,r)) ;
 ASAMG0("KAPITAL","TFTAX",r)     = SUM((i,tff),SAMG(i,tff,r)) ;
 ASAMG0("KAPITAL","GOVTN",r)     = SUM((i,g),SAMG(i,g,r)) ;
 ASAMG0("KAPITAL","KAPITAL",r)   = SUM((i,ip),SAMG(i,ip,r)) ;
 ASAMG0("KAPITAL","MARGS",r)     = SUM((i,owatpmarg),SAMG(i,owatpmarg,r)) ;
 ASAMG0("KAPITAL","WORLD",r)     = SUM((i,w),SAMG(i,w,r)) ;

 ASAMG0("MARGS","COMMDTY",r)     = SUM((owatpmarg,c),SAMG(owatpmarg,c,r)) ;
 ASAMG0("MARGS","ACTIVITY",r)    = SUM((owatpmarg,a),SAMG(owatpmarg,a,r)) ;
 ASAMG0("MARGS","VALUAD",r)      = SUM((owatpmarg,f),SAMG(owatpmarg,f,r)) ;
 ASAMG0("MARGS","HHOLDS",r)      = SUM((owatpmarg,h),SAMG(owatpmarg,h,r)) ;
 ASAMG0("MARGS","TMTAX",r)       = SUM((owatpmarg,tmr),SAMG(owatpmarg,tmr,r)) ;
 ASAMG0("MARGS","TETAX",r)       = SUM((owatpmarg,ter),SAMG(owatpmarg,ter,r)) ;
 ASAMG0("MARGS","TFTAX",r)       = SUM((owatpmarg,tff),SAMG(owatpmarg,tff,r)) ;
 ASAMG0("MARGS","GOVTN",r)       = SUM((owatpmarg,g),SAMG(owatpmarg,g,r)) ;
 ASAMG0("MARGS","KAPITAL",r)     = SUM((owatpmarg,i),SAMG(owatpmarg,i,r)) ;
 ASAMG0("MARGS","MARGS",r)       = SUM((owatpmarg,owatpmargp),
                                          SAMG(owatpmarg,owatpmargp,r)) ;
 ASAMG0("MARGS","WORLD",r)       = SUM((owatpmarg,w),SAMG(owatpmarg,w,r)) ;

 ASAMG0("WORLD","COMMDTY",r)     = SUM((w,c),SAMG(w,c,r)) ;
 ASAMG0("WORLD","ACTIVITY",r)    = SUM((w,a),SAMG(w,a,r)) ;
 ASAMG0("WORLD","VALUAD",r)      = SUM((w,f),SAMG(w,f,r)) ;
 ASAMG0("WORLD","HHOLDS",r)      = SUM((w,h),SAMG(w,h,r)) ;
 ASAMG0("WORLD","TMTAX",r)       = SUM((w,tmr),SAMG(w,tmr,r)) ;
 ASAMG0("WORLD","TETAX",r)       = SUM((w,ter),SAMG(w,ter,r)) ;
 ASAMG0("WORLD","TFTAX",r)       = SUM((w,tff),SAMG(w,tff,r)) ;
 ASAMG0("WORLD","GOVTN",r)       = SUM((w,g),SAMG(w,g,r)) ;
 ASAMG0("WORLD","KAPITAL",r)     = SUM((w,i),SAMG(w,i,r)) ;
 ASAMG0("WORLD","MARGS",r)       = SUM((w,owatpmarg),SAMG(w,owatpmarg,r)) ;
 ASAMG0("WORLD","WORLD",r)       = SUM((w,wp),SAMG(w,wp,r)) ;

 ASAMG0("TOTALS",ssnp,r)          = SUM(ssn,ASAMG0(ssn,ssnp,r)) ;
 ASAMG0(ssn,"TOTALS",r)          = SUM(ssnp,ASAMG0(ssn,ssnp,r)) ;

PARAMETER
 CHECK0(r)     Differences in Row and Column totals of ASAMG0
 ;

 CHECK0(r) = SUM(ssn,((ASAMG0(ssn,"TOTALS",r)-ASAMG0("TOTALS",ssn,r)))) ;

 ABORT $(SUM(r,CHECK0(r) GT 0.000005))
"ASAMG0 ROW AND COLUMN SUMS NOT EQUAL" ;

OPTION DECIMALS=6 ;

DISPLAY CHECK0, ASAMG0 ;

OPTION DECIMALS=3 ;

* Identifying illegal entries and aborting if present

 ABORT $(SUM(r,ASAMG0("COMMDTY","COMMDTY",r)) NE 0.0)
 "ASAMG0(COMMDTY,COMMDTY,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("COMMDTY","VALUAD",r)) NE 0.0)
 "ASAMG0(COMMDTY,VALUAD,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("COMMDTY","TMTAX",r)) NE 0.0)
 "ASAMG0(COMMDTY,TMTAX,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("COMMDTY","TETAX",r)) NE 0.0)
 "ASAMG0(COMMDTY,TETAX,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("COMMDTY","TFTAX",r)) NE 0.0)
 "ASAMG0(COMMDTY,TFTAX,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("COMMDTY","MARGS",r)) NE 0.0)
 "ASAMG0(COMMDTY,MARGS,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("ACTIVITY","ACTIVITY",r)) NE 0.0)
 "ASAMG0(ACTIVITY,ACTIVITY,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("ACTIVITY","VALUAD",r)) NE 0.0)
 "ASAMG0(ACTIVITY,VALUAD,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("ACTIVITY","HHOLDS",r)) NE 0.0)
 "ASAMG0(ACTIVITY,HHOLDS,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("ACTIVITY","TMTAX",r)) NE 0.0)
 "ASAMG0(ACTIVITY,TMTAX,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("ACTIVITY","TETAX",r)) NE 0.0)
 "ASAMG0(ACTIVITY,TETAX,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("ACTIVITY","TFTAX",r)) NE 0.0)
 "ASAMG0(ACTIVITY,TFTAX,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("ACTIVITY","GOVTN",r)) NE 0.0)
 "ASAMG0(ACTIVITY,GOVTN,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("ACTIVITY","KAPITAL",r)) NE 0.0)
 "ASAMG0(ACTIVITY,KAPITAL,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("ACTIVITY","MARGS",r)) NE 0.0)
 "ASAMG0(ACTIVITY,MARGS,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("ACTIVITY","WORLD",r)) NE 0.0)
 "ASAMG0(ACTIVITY,WORLD,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("VALUAD","COMMDTY",r)) NE 0.0)
 "ASAMG0(VALUAD,COMMDTY,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("VALUAD","VALUAD",r)) NE 0.0)
 "ASAMG0(VALUAD,VALUAD,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("VALUAD","HHOLDS",r)) NE 0.0)
 "ASAMG0(VALUAD,HHOLDS,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("VALUAD","TMTAX",r)) NE 0.0)
 "ASAMG0(VALUAD,TMTAX,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("VALUAD","TETAX",r)) NE 0.0)
 "ASAMG0(VALUAD,TETAX,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("VALUAD","TFTAX",r)) NE 0.0)
 "ASAMG0(VALUAD,TFTAX,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("VALUAD","GOVTN",r)) NE 0.0)
 "ASAMG0(VALUAD,GOVTN,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("VALUAD","KAPITAL",r)) NE 0.0)
 "ASAMG0(VALUAD,KAPITAL,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("VALUAD","MARGS",r)) NE 0.0)
 "ASAMG0(VALUAD,MARGS,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("VALUAD","WORLD",r)) NE 0.0)
 "ASAMG0(VALUAD,WORLD,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("HHOLDS","COMMDTY",r)) NE 0.0)
 "ASAMG0(HHOLDS,COMMDTY,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("HHOLDS","ACTIVITY",r)) NE 0.0)
 "ASAMG0(HHOLDS,ACTIVITY,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("HHOLDS","HHOLDS",r)) NE 0.0)
 "ASAMG0(HHOLDS,HHOLDS,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("HHOLDS","TMTAX",r)) NE 0.0)
 "ASAMG0(HHOLDS,TMTAX,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("HHOLDS","TETAX",r)) NE 0.0)
 "ASAMG0(HHOLDS,TETAX,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("HHOLDS","TFTAX",r)) NE 0.0)
 "ASAMG0(HHOLDS,TFTAX,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("HHOLDS","GOVTN",r)) NE 0.0)
 "ASAMG0(HHOLDS,GOVTN,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("HHOLDS","KAPITAL",r)) NE 0.0)
 "ASAMG0(HHOLDS,KAPITAL,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("HHOLDS","MARGS",r)) NE 0.0)
 "ASAMG0(HHOLDS,MARGS,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("HHOLDS","WORLD",r)) NE 0.0)
 "ASAMG0(HHOLDS,WORLD,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("TMTAX","ACTIVITY",r)) NE 0.0)
 "ASAMG0(TMTAX,ACTIVITY,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("TMTAX","VALUAD",r)) NE 0.0)
 "ASAMG0(TMTAX,VALUAD,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("TMTAX","HHOLDS",r)) NE 0.0)
 "ASAMG0(TMTAX,HHOLDS,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("TMTAX","TMTAX",r)) NE 0.0)
 "ASAMG0(TMTAX,TMTAX,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("TMTAX","TETAX",r)) NE 0.0)
 "ASAMG0(TMTAX,TETAX,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("TMTAX","GOVTN",r)) NE 0.0)
 "ASAMG0(TMTAX,GOVTN,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("TMTAX","KAPITAL",r)) NE 0.0)
 "ASAMG0(TMTAX,KAPITAL,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("TMTAX","MARGS",r)) NE 0.0)
 "ASAMG0(TMTAX,MARGS,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("TMTAX","WORLD",r)) NE 0.0)
 "ASAMG0(TMTAX,WORLD,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("TETAX","ACTIVITY",r)) NE 0.0)
 "ASAMG0(TETAX,ACTIVITY,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("TETAX","VALUAD",r)) NE 0.0)
 "ASAMG0(TETAX,VALUAD,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("TETAX","HHOLDS",r)) NE 0.0)
 "ASAMG0(TETAX,HHOLDS,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("TETAX","TMTAX",r)) NE 0.0)
 "ASAMG0(TETAX,TMTAX,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("TETAX","TETAX",r)) NE 0.0)
 "ASAMG0(TETAX,TETAX,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("TETAX","GOVTN",r)) NE 0.0)
 "ASAMG0(TETAX,GOVTN,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("TETAX","KAPITAL",r)) NE 0.0)
 "ASAMG0(TETAX,KAPITAL,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("TETAX","MARGS",r)) NE 0.0)
 "ASAMG0(TETAX,MARGS,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("TETAX","WORLD",r)) NE 0.0)
 "ASAMG0(TETAX,WORLD,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("TFTAX","COMMDTY",r)) NE 0.0)
 "ASAMG0(TFTAX,COMMDTY,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("TFTAX","VALUAD",r)) NE 0.0)
 "ASAMG0(TFTAX,VALUAD,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("TFTAX","HHOLDS",r)) NE 0.0)
 "ASAMG0(TFTAX,HHOLDS,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("TFTAX","TMTAX",r)) NE 0.0)
 "ASAMG0(TFTAX,TMTAX,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("TFTAX","TETAX",r)) NE 0.0)
 "ASAMG0(TFTAX,TETAX,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("TFTAX","TFTAX",r)) NE 0.0)
 "ASAMG0(TFTAX,TFTAX,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("TFTAX","KAPITAL",r)) NE 0.0)
 "ASAMG0(TFTAX,KAPITAL,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("TFTAX","MARGS",r)) NE 0.0)
 "ASAMG0(TFTAX,MARGS,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("TFTAX","WORLD",r)) NE 0.0)
 "ASAMG0(TFTAX,WORLD,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("GOVTN","MARGS",r)) NE 0.0)
 "ASAMG0(GOVTN,MARGS,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("GOVTN","WORLD",r)) NE 0.0)
 "ASAMG0(GOVTN,WORLD,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("KAPITAL","COMMDTY",r)) NE 0.0)
 "ASAMG0(KAPITAL,COMMDTY,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("KAPITAL","ACTIVITY",r)) NE 0.0)
 "ASAMG0(KAPITAL,ACTIVITY,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("KAPITAL","TMTAX",r)) NE 0.0)
 "ASAMG0(KAPITAL,TMTAX,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("KAPITAL","TETAX",r)) NE 0.0)
 "ASAMG0(KAPITAL,TETAX,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("KAPITAL","MARGS",r)) NE 0.0)
 "ASAMG0(KAPITAL,MARGS,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("MARGS","ACTIVITY",r)) NE 0.0)
 "ASAMG0(MARGS,ACTIVITY,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("MARGS","VALUAD",r)) NE 0.0)
 "ASAMG0(MARGS,VALUAD,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("MARGS","HHOLDS",r)) NE 0.0)
 "ASAMG0(MARGS,HHOLDS,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("MARGS","TMTAX",r)) NE 0.0)
 "ASAMG0(MARGS,TMTAX,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("MARGS","TETAX",r)) NE 0.0)
 "ASAMG0(MARGS,TETAX,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("MARGS","GOVTN",r)) NE 0.0)
 "ASAMG0(MARGS,GOVTN,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("MARGS","KAPITAL",r)) NE 0.0)
 "ASAMG0(MARGS,KAPITAL,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("MARGS","MARGS",r)) NE 0.0)
 "ASAMG0(MARGS,MARGS,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("MARGS","WORLD",r)) NE 0.0)
 "ASAMG0(MARGS,WORLD,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("WORLD","ACTIVITY",r)) NE 0.0)
 "ASAMG0(WORLD,ACTIVITY,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("WORLD","VALUAD",r)) NE 0.0)
 "ASAMG0(WORLD,VALUAD,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("WORLD","HHOLDS",r)) NE 0.0)
 "ASAMG0(WORLD,HHOLDS,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("WORLD","TMTAX",r)) NE 0.0)
 "ASAMG0(WORLD,TMTAX,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("WORLD","TETAX",r)) NE 0.0)
 "ASAMG0(WORLD,TETAX,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("WORLD","GOVTN",r)) NE 0.0)
 "ASAMG0(WORLD,GOVTN,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("WORLD","KAPITAL",r)) NE 0.0)
 "ASAMG0(WORLD,KAPITAL,r) non zero" ;

 ABORT $(SUM(r,ASAMG0("WORLD","WORLD",r)) NE 0.0)
 "ASAMG0(WORLD,WORLD,r) non zero" ;

* -------------- END OF anar_t data diagnostics -------------------------
