*##################### 16. RESULTS ANALYSES FILE #########################

$ontext
The various files for the analysis of results can be called here or by using
programme analyse.gms to carry out the same actions using results stored
in GDX

EACH COMPONENT IS INDEPENDENT, i.e., each component only makes use of the
results saved into the standard GDX results file that is produced by the
simulations module. This includes the levels values for the model variables,
all the initial values of variables, all the model parameter values, all the
model and simulation sets

$offtext

* ------- WRITE OUT LEVELS RESULTS ---------------------------------------
$ontext
This $INCLUDE file exports the levels results to GDX as 'anar_t_reslevel.gdx'

'anar_t_reslevel.gdx' is the default name for the results file
its name can be changed in the $INCLUDE file
$offtext

If(res_cont("reslevel") = 1,

$INCLUDE 5_analysis\anar_t_reslevel.inc

  ) ;
  
* ------- Results Macros

$INCLUDE 5_analysis\anar_t_macros.inc
  
* ------- New MicroSAM Results -------------------------------------------
$ontext
This $INCLUDE file generates and exports a global SAM for each experiment
to GDX as 'anar_t_ressamg.gdx'

'anar_t_ressamg.gdx' is the default name for the results file
its name can be changed in the $INCLUDE file
$offtext

Parameter
 SAMG3(sac,sacp,r,%res_dimen%)    New Global SAM for each simulation

 SAMG3CHK(sac,r,%res_dimen%)      CHK on row and column totals
 CNTSAMG3CHK(r,%res_dimen%)       Count of non zero entries in SAMG3CHK

   ;

If(res_cont("ressamg") = 1,

$INCLUDE 5_analysis\anar_t_ressamg.inc

  ) ;
   
* ------- Macroeconomic Results -----------------------
$ontext
This $INCLUDE file generates and exports various summary macroeconomic
totals, shares and proportionate changes to GDX as 'womod_resmacro.gdx'

'anar_t_resmacro.gdx' is the default name for the results file
its name can be changed in the $INCLUDE file
$offtext

$ontext
This $INCLUDE file generates and exports various summary macroeconomic
totals, shares and proportionate changes to GDX as 'anar_resmacro.gdx'

'anar_resmacro.gdx' is the default name for the results file
its name can be changed in the $INCLUDE file
$offtext

Set

 basis    level and percentage changes /
 lev      level
 perc     percentage change
 
 /
 
 base      nominal and real  /
 nomin    Nominal base
 real     Real base
 
 /
  ;

* ------- 1. Define Macroeconomic Tables -------------------------------------

* This section defines the Macroeconomic tables that are reported

PARAMETER

*Macroeconomic tables - indexed on stab1

 resMACRO(stab1,r,basis,base,%res_dimen%)   Macro Economic totals

 nMACROSH1(stab1,r,%res_dimen%)     Nominal Macro shares in GDP Expenditure
 nMACROSH2(stab1,r,%res_dimen%)     Nominal Macro shares in Domestic Absorption

  ;

If(res_cont("resmacro") = 1,

$INCLUDE 5_analysis\anar_t_resmacro.inc

  ) ;

* ------- Structural Results -----------------------
$ontext
This $INCLUDE file generates and exports various summary structural
measures to GDX as 'womod_resstruct.gdx'

'anar_t_resstruct.gdx' is the default name for the results file
its name can be changed in the $INCLUDE file
$offtext

* ------- 1. Define Structural Tables -------------------------------------

* This section defines the structural tables that are used to report
* descriptive statistics for the database used for this model

PARAMETERS

* --- Commodity Tables ---

* Trade shares - indexed on stab2
 nIMPORTSH(stab2,w,c,r,%res_dimen%)  Import shares in c from w by reg
 nEXPORTSH(stab2,c,w,r,%res_dimen%)  Export shares in c to w by reg

* Commodity account shares - indexed on stab3
 nCOMMODSH(stab3,c,r,%res_dimen%)    Commodity shares in c by reg

* --- Activity Tables - indexed on stab4

 nACTIVSH(stab4,a,r,%res_dimen%)      Activity shares in a by reg

* --- Factor Tables - indexed on stab5

 nFACTUSESH(stab5,f,a,r,%res_dimen%)  factor use by activities and region

* ---Factor adjustment

 FACTADJ(f,r,%res_dimen%)              Factor adjustment across activities

* ---- Exports by aggregate commodities and/or regions

 EXPORT_TOT(w,r,%res_dimen%)           Export totals valued in world prices
 EXPORT_DIF(w,r,%res_dimen%)           Change in Exp totals valued in world prices
 EXPORT_DIF_AGG(wagg,ragg,%res_dimen%) Change in Exp totals to agg regions
 EXPORT_TOT_SH(w,r,%res_dimen%)        Export shares to wgn by region
 EXP_CAGG_TOT(cagg,w,r,%res_dimen%)    Export of commodity aggregates world pr

* ---- Imports by aggregate commodities and/or regions

 IMPORT_TOT(w,r,%res_dimen%)           Import totals valued in world prices
 IMPORT_TOT_SH(w,r,%res_dimen%)        Import shares to wgn by region
 IMP_CAGG_TOT(w,cagg,r,%res_dimen%)    Import of commodity aggregates world pr

* ---- Total Trade by aggregate commodities and/or regions

 tradetot(r,w,%res_dimen%)             total trade FOB
 test_tradepc(r,w,%res_dimen%)         percent change in total trade
 tradetot2(ragg,wagg,%res_dimen%)      total trade by aggregatre region FOB
 tradetotpc(ragg,wagg,%res_dimen%)     percent change in exports by agg region
 tradetotsh(ragg,wagg,%res_dimen%)     trade share by aggregatre region FOB
 tradeshdiff(ragg,wagg,%res_dimen%)    absolute change in trade shares

  ;


If(res_cont("resstruct") = 1,

*$INCLUDE 5_analysis\anar_t_resstruct.inc

  ) ;
   
* ------- Welfare Results Analysis -----------------------------------
$ontext
This $INCLUDE file generates and exports various summary welfare
measures to GDX as 'anar_t_reswelf.gdx'

'anar_t_reswelf.gdx' is the default name for the results file
its name can be changed in the $INCLUDE file
$offtext

Parameter

 resEV(h,r,%res_dimen%)         EV by household on consumption
 resEV_cap(h,r,%res_dimen%)     EV per capita by household on consumption

 resIC(h,r,%res_dimen%)         LES Indirect compensation by h'hold on consumption
 resIC_cap(h,r,%res_dimen%)     LES IC per capita by h'hold on consumption

 resEV_alt(h,r,%res_dimen%)     LES Alternative EV by h'hold on consumption
 resEV_alt_cap(h,r,%res_dimen%) LES Alt EV per capita by h'hold on consumption

 pop(h,r)                    Population by household and region


 resEV_H_slut(h,r,%res_dimen%)  Slutsky approx EV by household on consumption
 resEV_R_slut(r,%res_dimen%)    Slutsky approx EV by region on consumption

   ;

 pop(h,r)     = 0.0 ;
 

If(res_cont("reswelf") = 1,

$INCLUDE 5_analysis\anar_t_reswelf.inc

  ) ;
 
* ------- Price Indices Results --------------------------------------

$ontext
This $INCLUDE file generates and exports various price indices
to GDX as 'anar_t_resindex.gdx'

'anar_t_resindex.gdx' is the default name for the results file
its name can be changed in the $INCLUDE file
$offtext

*---- 6a. Define Price Index Sets and Tables

Set
 pind    price indices  ;
 
$GDXIN data_in.gdx

$LOADdc pind

$GDXIN

 
Parameter

* Price indices
 resP_IND(pind,r,%res_dimen%)     Price indices results
 resCPI_H_IND(h,r,%res_dimen%)    CPI indices results for households
 resPPI_A_IND(a,r,%res_dimen%)    PPI indices results for activities
 
* domestic Price index weights
 wt_pd(c,r)     weight of commodity c in PD index for r
 wt_pqs(c,r)    Weights for Supply price of composite commodity c index for r (base = 100)
 wt_pqd(c,r)    Weights for Purchaser price of composite commodity c index for r (base = 100)
 wt_pqcd(c,r)   Weights for Purchaser price of natural cc private final demand index for r (base = 100)
 
* Production price weights
 wt_pxc(c,r)    Weights for Producer price for composite domestic output index for r (base = 100)
 wt_px(a,r)     Weights for Composite price of output by activity a for r
 wt_pva(a,r)    Weights for Value added price for activity a level 1 of nest index for r (base = 100)
 wt_pint(a,r)   Weights for Price of aggregate intermediate input index for r (base = 100) 

 wt_wf(f,r)     Weights for Price of factor f index (base = 100)

* trade price index weights
 wt_pwe(c,r)    weight of commodity c for r in pwe index
 wt_pwm(c,r)    weight of commodity c for r in pwm index
 wt_pe(c,r)     weight of commodity c for r in pe index
 wt_pm(c,r)     weight of commodity c for r in pm index
 wt_pw(*,r)     weight of aggregate exports-imports in pw for r (tradables) index

* CPI weights
 wt_cpi_h(c,h,r)  Weights for household CPI for r
 
* PPI weights
 wt_ppi_a(a,c,r)  Weights for activity PPI for r
 
   ;
   
$ontext
This $INCLUDE file generates and exports various price indices
to GDX as 'anar_t_resindex.gdx'

'anar_t_resindex.gdx' is the default name for the results file
its name can be changed in the $INCLUDE file
$offtext


If(res_cont("resindex") = 1,

$INCLUDE 5_analysis\anar_t_resindex.inc

  ) ;
  

* ------- CALCULATE AND WRITE OUT PERCENTAGE CHANGE RESULTS ----------
$ontext
This $INCLUDE file generates and exports the proportionate change results
for ALL variables to GDX as 'anar_t_respercent.gdx'

NB The same parameter names are used as for the levels results

anar_t_respercent.gdx' is the default name for the results file
its name can be changed in the $INCLUDE file
$offtext

$SETGLOBAL res  perc_

$INCLUDE 5_Analysis\anar_t_resparm.inc

If(res_cont("resperc") = 1,

$INCLUDE 5_Analysis\anar_t_resperc.inc

  ) ;

$DROPGLOBAL res


* ---------- END OF anar_t results analysis file -----------
