* ----------------- Macroeconomic Tables --------------------------------


* ------- Generating Macroeconomic Tables -----------------------------
$onMacro

* Measures of Absorption from Expenditure

 resMACRO("stABSORP",r,"lev","nomin",%res_dimen%)  = m_NT_QCD + m_NT_QGD + m_NT_QINVD ;
 resMACRO("stABSORP",r,"lev","real",%res_dimen%)   = m_RT_QCD + m_RT_QGD + m_RT_QINVD ;
 resMACRO("stABSORP",r,"perc","nomin",%res_dimen%)$(m_BT_QCD + m_BT_QGD + m_BT_QINVD)
                                                 = {[(m_NT_QCD + m_NT_QGD + m_NT_QINVD)
                                                   /(m_BT_QCD + m_BT_QGD + m_BT_QINVD)] -1} * 100 ;
 resMACRO("stABSORP",r,"perc","real",%res_dimen%)$(m_BT_QCD + m_BT_QGD + m_BT_QINVD)
                                                  = {[(m_RT_QCD + m_RT_QGD + m_RT_QINVD)
                                                    /(m_BT_QCD + m_BT_QGD + m_BT_QINVD)] -1} * 100 ;

* Measures of GDP from Expenditure

                                                    
 resMACRO("stGDP",r,"lev","nomin",%res_dimen%)     = m_NT_QCD + m_NT_QGD + m_NT_QINVD + m_NT_QWE - m_NT_QWM ;
 resMACRO("stGDP",r,"lev","real",%res_dimen%)      = m_RT_QCD + m_RT_QGD + m_RT_QINVD + m_RT_QWE - m_RT_QWM ;
 resMACRO("stGDP",r,"perc","nomin",%res_dimen%)$(m_BT_QCD + m_BT_QGD + m_BT_QINVD + m_BT_QWE - m_BT_QWM)
                                                   = {[(m_NT_QCD + m_NT_QGD + m_NT_QINVD + m_NT_QWE - m_NT_QWM)
                                                     /(m_BT_QCD + m_BT_QGD + m_BT_QINVD + m_BT_QWE - m_BT_QWM)] -1} * 100 ;
                                                     
 resMACRO("stGDP",r,"perc","real",%res_dimen%)$(m_BT_QCD + m_BT_QGD + m_BT_QINVD + m_BT_QWE - m_BT_QWM)
                                                   = {[(m_RT_QCD + m_RT_QGD + m_RT_QINVD + m_RT_QWE - m_RT_QWM)
                                                     /(m_BT_QCD + m_BT_QGD + m_BT_QINVD + m_BT_QWE - m_BT_QWM)] -1} * 100 ;


* Measures of Household Private Consumption at PURCHASER Prices

 resMACRO("stQCDTOT",r,"lev","nomin",%res_dimen%)= m_NT_QCD ;
 resMACRO("stQCDTOT",r,"lev","real",%res_dimen%) = m_RT_QCD ;
 resMACRO("stQCDTOT",r,"perc","nomin",%res_dimen%)$m_BT_QCD  = ({m_NT_QCD/m_BT_QCD}-1)*100 ;
 resMACRO("stQCDTOT",r,"perc","real",%res_dimen%) $m_BT_QCD  = ({m_RT_QCD/m_BT_QCD}-1)*100 ;
 
* Measures of Government Consumption at PURCHASER Prices

 resMACRO("stQGDTOT",r,"lev","nomin",%res_dimen%)= m_NT_QGD ;                  
 resMACRO("stQGDTOT",r,"lev","real",%res_dimen%) = m_RT_QGD ;                  
 resMACRO("stQGDTOT",r,"perc","nomin",%res_dimen%)$m_BT_QGD  = ({m_NT_QGD/m_BT_QGD}-1)*100 ;
 resMACRO("stQGDTOT",r,"perc","real",%res_dimen%) $m_BT_QGD  = ({m_RT_QGD/m_BT_QGD}-1)*100 ;

* Measures of Investment Consumption at PURCHASER Prices

 resMACRO("stQINVTOT",r,"lev","nomin",%res_dimen%)= m_NT_QINVD ;
 resMACRO("stQINVTOT",r,"lev","real",%res_dimen%) = m_RT_QINVD ;         
 resMACRO("stQINVTOT",r,"perc","nomin",%res_dimen%)$m_BT_QINVD  = ({m_NT_QINVD/m_BT_QINVD}-1)*100 ;
 resMACRO("stQINVTOT",r,"perc","real",%res_dimen%) $m_BT_QINVD  = ({m_RT_QINVD/m_BT_QINVD}-1)*100 ;

* Measures of Import Expenditures at BASIC Prices

 resMACRO("stIMPORT",r,"lev","nomin",%res_dimen%)= m_NT_QM ;                  
 resMACRO("stIMPORT",r,"lev","real",%res_dimen%) = m_RT_QM ;                  
 resMACRO("stIMPORT",r,"perc","nomin",%res_dimen%)$m_BT_QM  = ({m_NT_QM/m_BT_QM}-1)*100 ;
 resMACRO("stIMPORT",r,"perc","real",%res_dimen%) $m_BT_QM  = ({m_RT_QM/m_BT_QM}-1)*100 ;

* Measures of Export Incomes at BASIC Prices

 resMACRO("stEXPORT",r,"lev","nomin",%res_dimen%)= m_NT_QE ;                  
 resMACRO("stEXPORT",r,"lev","real",%res_dimen%) = m_RT_QE ;                  
 resMACRO("stEXPORT",r,"perc","nomin",%res_dimen%)$m_BT_QE  = ({m_NT_QE/m_BT_QE}-1)*100 ;
 resMACRO("stEXPORT",r,"perc","real",%res_dimen%) $m_BT_QE  = ({m_RT_QE/m_BT_QE}-1)*100 ;
 
* Measures of Domestic Supply at BASIC prices

 resMACRO("stSUPPLY",r,"lev","nomin",%res_dimen%)= m_NT_QXC ;                  
 resMACRO("stSUPPLY",r,"lev","real",%res_dimen%) = m_RT_QXC ;                  
 resMACRO("stSUPPLY",r,"perc","nomin",%res_dimen%)$m_BT_QXC  = ({m_NT_QXC/m_BT_QXC}-1)*100 ;
 resMACRO("stSUPPLY",r,"perc","real",%res_dimen%) $m_BT_QXC  = ({m_RT_QXC/m_BT_QXC}-1)*100 ;

* Measures of Intermediate Input use at PURCHASER prices

 resMACRO("stUSE",r,"lev","nomin",%res_dimen%)= m_NT_QINTD ;                  
 resMACRO("stUSE",r,"lev","real",%res_dimen%) = m_RT_QINTD ;                  
 resMACRO("stUSE",r,"perc","nomin",%res_dimen%)$m_BT_QINTD  = ({m_NT_QINTD/m_BT_QINTD}-1)*100 ;
 resMACRO("stUSE",r,"perc","real",%res_dimen%) $m_BT_QINTD  = ({m_RT_QINTD/m_BT_QINTD}-1)*100 ;
 
* Measures of Domestic Factor Income

 resMACRO("stYFTOT",r,"lev","nomin",%res_dimen%)= m_NT_YF ;                  
 resMACRO("stYFTOT",r,"lev","real",%res_dimen%) = m_RT_YF ;                  
 resMACRO("stYFTOT",r,"perc","nomin",%res_dimen%)$m_BT_YF  = ({m_NT_YF/m_BT_YF}-1)*100 ;
 resMACRO("stYFTOT",r,"perc","real",%res_dimen%) $m_BT_YF  = ({m_RT_YF/m_BT_YF}-1)*100 ;
 
* Measures of Domestic Labour Income

 resMACRO("stYFLABTOT",r,"lev","nomin",%res_dimen%)= m_NT_YLAB ;                  
 resMACRO("stYFLABTOT",r,"lev","real",%res_dimen%) = m_RT_YLAB ;                  
 resMACRO("stYFLABTOT",r,"perc","nomin",%res_dimen%)$m_BT_YLAB  = ({m_NT_YLAB/m_BT_YLAB}-1)*100 ;
 resMACRO("stYFLABTOT",r,"perc","real",%res_dimen%) $m_BT_YLAB  = ({m_RT_YLAB/m_BT_YLAB}-1)*100 ;
 
* Measures of Household Income

 resMACRO("stYHTOT",r,"lev","nomin",%res_dimen%)= m_NT_YH ;
 resMACRO("stYHTOT",r,"lev","real",%res_dimen%) = m_RT_YH ;
 resMACRO("stYHTOT",r,"perc","nomin",%res_dimen%)$m_BT_YH  = ({m_NT_YH/m_BT_YH}-1)*100 ;
 resMACRO("stYHTOT",r,"perc","real",%res_dimen%) $m_BT_YH  = ({m_RT_YH/m_BT_YH}-1)*100 ;
                                                                                                                               
* Measures of Government Income

 resMACRO("stYGTOT",r,"lev","nomin",%res_dimen%) = m_NT_YG ;
 resMACRO("stYGTOT",r,"lev","real",%res_dimen%)  = m_RT_YG ;
 resMACRO("stYGTOT",r,"perc","nomin",%res_dimen%)$m_BT_YG  = ({m_NT_YG/m_BT_YG}-1)*100 ;
 resMACRO("stYGTOT",r,"perc","real",%res_dimen%)$m_BT_YG   = ({m_RT_YG/m_BT_YG}-1)*100 ;
                                                                                                                
* Measures of Total Savings

 resMACRO("stTOTSAV",r,"lev","nomin",%res_dimen%)= m_NT_TOTSAV ;
 resMACRO("stTOTSAV",r,"lev","real",%res_dimen%) = m_RT_TOTSAV ;
 resMACRO("stTOTSAV",r,"perc","nomin",%res_dimen%)$m_BT_TOTSAV  = ({m_NT_TOTSAV/m_BT_TOTSAV}-1)*100 ;
 resMACRO("stTOTSAV",r,"perc","real",%res_dimen%) $m_BT_TOTSAV  = ({m_RT_TOTSAV/m_BT_TOTSAV}-1)*100 ;
                                                               
* Measures of Depreciation

 resMACRO("stDPREC",r,"lev","nomin",%res_dimen%)= m_NT_DPREC ;
 resMACRO("stDPREC",r,"lev","real",%res_dimen%) = m_RT_DPREC ;
 resMACRO("stDPREC",r,"perc","nomin",%res_dimen%)$m_BT_DPREC  = ({m_NT_DPREC/m_BT_DPREC}-1)*100 ;
 resMACRO("stDPREC",r,"perc","real",%res_dimen%) $m_BT_DPREC  = ({m_RT_DPREC/m_BT_DPREC}-1)*100 ;
 
* Measures of Internal Balance

 resMACRO("stKAPGOV",r,"lev","nomin",%res_dimen%)= m_NT_KAPGOV ;
 resMACRO("stKAPGOV",r,"lev","real",%res_dimen%) = m_RT_KAPGOV ;
 resMACRO("stKAPGOV",r,"perc","nomin",%res_dimen%)$m_BT_KAPGOV  = ({m_NT_KAPGOV/m_BT_KAPGOV}-1)*100 ;
 resMACRO("stKAPGOV",r,"perc","real",%res_dimen%) $m_BT_KAPGOV  = ({m_RT_KAPGOV/m_BT_KAPGOV}-1)*100 ;
                                                               
* Measures of External Balance

 resMACRO("stKAPWOR",r,"lev","nomin",%res_dimen%)= m_NT_KAPWOR ;
 resMACRO("stKAPWOR",r,"lev","real",%res_dimen%) = m_RT_KAPWOR ;
 resMACRO("stKAPWOR",r,"perc","nomin",%res_dimen%)$m_BT_KAPWOR  = ({m_NT_KAPWOR/m_BT_KAPWOR}-1)*100 ;
 resMACRO("stKAPWOR",r,"perc","real",%res_dimen%) $m_BT_KAPWOR  = ({m_RT_KAPWOR/m_BT_KAPWOR}-1)*100 ;
 

 
$ontext

 resMACRO("stYFDISPTOT","lev","nomin",%res_dimen%)= SUM(f,lev_YFDISP(f,%res_dimen%)) ;

 resMACRO("stYFDISPTOT","perc","nomin",%res_dimen%)= SUM(f,lev_YFDISP(f,%res_dimen%)) ;

 
$offtext

* --- Macroeconomic Shares ---

* Share of household consumption in GDPEXP
 nMACROSH1("stQCDTOT",r,%res_dimen%)$resMACRO("stGDP",r,"lev","nomin",%res_dimen%)
            = m_NT_QCD/resMACRO("stGDP",r,"lev","nomin",%res_dimen%) ;

* Share of government consumption in GDPEXP
 nMACROSH1("stQGDTOT",r,%res_dimen%)$resMACRO("stGDP",r,"lev","nomin",%res_dimen%)
            = m_NT_QGD/resMACRO("stGDP",r,"lev","nomin",%res_dimen%) ;
            
* Share of investment consumption in GDPEXP
 nMACROSH1("stQINVTOT",r,%res_dimen%)$ resMACRO("stGDP",r,"lev","nomin",%res_dimen%)
            = m_NT_QINVD/resMACRO("stGDP",r,"lev","nomin",%res_dimen%) ;            

* Ratio of import demand to GDPEXP
 nMACROSH1("stIMPORT",r,%res_dimen%)$resMACRO("stGDP",r,"lev","nomin",%res_dimen%)
            = m_NT_QWM/resMACRO("stGDP",r,"lev","nomin",%res_dimen%) ;

* Ratio of export supply to GDPEXP
 nMACROSH1("stEXPORT",r,%res_dimen%)$resMACRO("stGDP",r,"lev","nomin",%res_dimen%)
            = m_NT_QWE/resMACRO("stGDP",r,"lev","nomin",%res_dimen%) ;

* Share of household consumption in ABSORP
 nMACROSH2("stQCDTOT",r,%res_dimen%)$resMACRO("stABSORP",r,"lev","nomin",%res_dimen%)
            = m_NT_QCD/resMACRO("stABSORP",r,"lev","nomin",%res_dimen%) ;

* Share of government consumption in ABSORP
 nMACROSH2("stQGDTOT",r,%res_dimen%)$resMACRO("stABSORP",r,"lev","nomin",%res_dimen%)
            = m_NT_QGD/resMACRO("stABSORP",r,"lev","nomin",%res_dimen%) ;

* Share of investment consumption in ABSORP
 nMACROSH2("stQINVTOT",r,%res_dimen%)$resMACRO("stABSORP",r,"lev","nomin",%res_dimen%)
            = m_NT_QINVD/resMACRO("stABSORP",r,"lev","nomin",%res_dimen%) ;

* Ration of import demand consumption to ABSORP
 nMACROSH2("stIMPORT",r,%res_dimen%)$resMACRO("stABSORP",r,"lev","nomin",%res_dimen%)
            = m_NT_QWM/resMACRO("stABSORP",r,"lev","nomin",%res_dimen%) ;

* Ratio of export supply to ABSORP
 nMACROSH2("stEXPORT",r,%res_dimen%)$resMACRO("stABSORP",r,"lev","nomin",%res_dimen%)
            = m_NT_QWE/resMACRO("stABSORP",r,"lev","nomin",%res_dimen%) ;


$offmacro
 
$offdotl

* ------- Exporting Macroeconomic Tables to GDX -----------------------------

* This writes the results data to GDX

Execute_Unload  '6_Results\%expt_res%\anar_t_resmacro.gdx',
                          resMACRO,
                          
                          nMACROSH2
                          nMACROSH1
                          
   ;

* ----------------- end of Macroeconomic Tables -----------------------------
