* -------------- anar_t Surplus labour closure ----------------------------

$ontext
     anar_t_cl_unemp.inc

                     CONDITION                                 REGIONS

     FEX        - Exchange rate FIXED                           rerfx
                - KAPWOR fixed                                  rerfxn

     Investment - savings rates FIXED                            All

     Government - Volume of consumption FIXED                    All
                - Tax rates FIXED                                All
                - KAPGOV FLEXIBLE                                All

     Factors    - Land sector - mobile & full                    All
                - Capital - mobile & full                        All
                - Unskilled labour - mobile & SURPLUS            All
                - Skilled labour - mobile & full                 All

     Numeraire  - CPI                                            All

$offtext

* Derivations from Base Macro Closure

*## FOREIGN EXCHANGE MARKET CLOSURE

* fix world numeraire in which foreign transactions are valued

 ERPI.FX                 = ERPI0 * numerchk ;

* globe transactions are in the numeraire currency

 ER.FX(g_glb)            = ERPI0 * numerchk;

* globe's trade balance is zero by definition of tship and the fact that
* there is only one imported commodity

$ontext
 The 'standard' presumption in this MODEL is that
   ONE of the exchange rate or the trade balance is FIXED for each region

 IF the exchange rate is FIXED the trade balance is the equilibrating variable.
 IF the trade balance is FIXED the exchange rate is the equilibrating variable.

$offtext

* EITHER the exchange rate is FIXED

* ER.FX(rgn)                = ER0(rgn) ;

* OR the trade balance is FIXED

 KAPWOR.FX(rgn)           = KAPWOR0(rgn) ;

*## INVESTMENT-SAVINGS CLOSURE
* IF aggregate investment is determined by aggregate savings
* i.e., the model is savings driven, then fix SADJ and DSHH
* Typically the actual/model savings rates are NOT fixed directly

* SADJ controls multiplictive changes in savings rates

* SADJ.FX(r)        = SADJ0(r) ;

* DSHH controls additive changes in savings rates
* NB DSHH needs to be used in conjunction with shh01

* DSHH.FX(r)         = DSHH0(r) ;

* ALTERNATIVELY the model is made investment driven
* If investment volume fixed then scaling factor is fixed

* IADJ.FX(r)         = IADJ0(r) ;

* OR if the value of investment is fixed the

* INVEST.FX(r)       = INVEST0(r) ;

* OR the shares of domestic final demand of investment is fixed

 INVESTSH.FX(r)     = INVESTSH0(r) ;

* Closure rule for Government savings is part of the Govt Closure Rules

*## GOVT CLOSURE RULES
* IF ALL tax rates are fixed
* AND Government consumption expenditure is fixed
* Then the equilibriating variable is Government Savings

* Tax rate scaling factors

* T*ADJ control multiplictive changes in tax rates

 TEADJ.FX(r)         = TEADJ0(r) ;
 TMADJ.FX(r)         = TMADJ0(r) ;
 TSADJ.FX(r)         = TSADJ0(r) ;
 TVADJ.FX(r)         = TVADJ0(r) ;
 TXADJ.FX(r)         = TXADJ0(r) ;
 TYFADJ.FX(r)        = TYFADJ0(r) ;
 TYHADJ.FX(r)        = TYHADJ0(r) ;
 TFADJ.FX(r)         = TFADJ0(r) ;

* Dt* control additive changes in tax rates
* NB DT* needs to be used in conjunction with t*01

 DTE.FX(r)           = DTE0(r) ;
 DTM.FX(r)           = DTM0(r) ;
 DTS.FX(r)           = DTS0(r) ;
 DTV.FX(r)           = DTV0(r) ;
 DTX.FX(r)           = DTX0(r) ;
 DTYF.FX(r)          = DTYF0(r) ;
 DTYH.FX(r)          = DTYH0(r) ;
 DTF.FX(r)           = DTF0(r) ;

* GOVERNMENT EXPENDITURE
* FIX volume

* QGDADJ.FX(r)        = QGDADJ0(r) ;

* OR FIX nominal

* EG.FX(r)           = EG0(r) ;

* OR FIX shares of final demand

 VGDSH.FX(r)         = VGDSH0(r) ;

* GOVERNMENT SAVINGS
* OR the internal balance / Govt savings can be fixed

* KAPGOV.FX(r)       = KAPGOV0(r) ;

*###### FACTOR MARKET CLOSURE

*# Base Factor Market Closure
* all factors are mobile and fully employed

 FS.FX(f,r)                  = FS0(f,r) ;
 WFDIST.FX(f,a,r)            = WFDIST0(f,a,r) ;
 WF.LO(f,r)                  = -inf ;
 WF.UP(f,r)                  = +inf ;

 WF.FX(ff,r)$fag(ff)         = WF0(ff,r) ;
 
$ontext

*####### Alternative Factor Market Clearing Conditions

    This code allows for configuring various factor market clearing options.
 For these examples the presumption is that the 'Base Factor Market Clearing'
 settings are overwritten below.

    The term 'Base Factor Market Clearing' does not imply any presumption
 that an assumption that 'all factors are mobile and fully employed' is
 either correct or appropriate (see the User Guide for more details)

    When changing factor market closure rules be careful to count how many
 conditions you relax, i.e., unfix, and how many you fix.

    The instructions below assume that the user will make the changes in
 factor market clearing conditions by over writing the conditions
 for all factors to be mobile and full employed.   

    SHORT RUN CONDITIONS - TO MAKE A FACTOR ACTIVITY SPECIFIC AND FIXED
 i)    Fix FD.FX("factor",a,"reg") AND WF.FX("factor",a,"reg")
 ii)   Fix WF.FX(ff,r)$fag(ff)
 iii)  Unfix WFDIST.FX("factor",a,"reg")
 iv)   FS.FX("factor","reg") is redundant BUT leave FIXED

    SURPLUS LABOUR CONDITIONS - TO ALLOW FOR A FACTOR IN SURPLUS SUPPLY
 i)  Unfix FS.FX("factor",r)
 ii) Fix WF.FX("factor",r) AND FS.LO("factor",r) and FS.UP("factor",r)

    TO CONTROL FACTOR USE BY ACTIVITY
       Adapt the SHORT RUN conditons, e.g., to FIX ALL factors in ONE
       activity in ONE region
 i)   Fix FD.FX(f,"activ","reg") AND WF.FX(f,"activ","reg")
 ii)  UNFIX WFDIST(f,"activ","reg")
 iii) Factor supplies are fixed and adjust through other activities

  STANDARD BLOCK of conditions for factor "fact" is

  FS.FX("fact",r)                    = FS0("fact",r) ;
  WFDIST.FX("fact",a,r)              = WFDIST0("fact",a,r) ;
  WF.LO("fact",r)                    = -inf ;
  WF.UP("fact",r)                    = +inf ;
  WFDIST.FX("fact","aserv",r)        = WFDIST0("fact","aserv",r) ;
  FD.FX("fact",a,r)                  = FD0("fact",a,r) ;
  WF.FX("fact",r)                    = WF0("fact",r) ;
  FS.LO("fact",r)                    = -inf ;
  FS.UP("fact",r)                    = +inf ;

$offtext

* ## Surplus labour factor market closure examples

* 1. Surplus labour closure - ONE factor and ALL regions
*$ontext
* First cancel previous settings

 FD.LO(k,a,r)         = -inf ;
 FD.UP(k,a,r)         = +inf ;
 
* Then setup new settings

 WF.FX("fUskil",r)       = WF0("fUskil",r) ;

 FS.LO("fUskil",r)       = -inf ;
 FS.UP("fUskil",r)       = +inf ;

*$offtext

* 2. Surplus labour closure - SEVERAL factors and ONE region
$ontext
* First cancel previous settings

 FD.LO(k,a,r)         = -inf ;
 FD.UP(k,a,r)         = +inf ;
 
* Then setup new settings

 WF.FX(l,"afr")           = WF0(l,"afr") ;

 FS.LO(l,"afr")           = -inf ;
 FS.UP(l,"afr")           = +inf ;

$offtext


* # Technology Closures for Factor Market

* NB SHIFT factors are fixed indirectly through the adjustment variables

* Technology for CES production functions for Level 1 of production nest

* To FIX ADX fix BOTH ADXADJ and DADX
* NB DADX needs to be used in conjunction with adx01

 ADXADJ.FX(r)        = ADXADJ0(r) ;
 DADX.FX(r)          = DADX0(r) ;

* Technology for CES aggregation functions for Level 2 of production nest

* To FIX ADVA fix BOTH ADVAADJ and DADVA
* NB DADVA needs to be used in conjunction with adva01

 ADVAADJ.FX(r)       = ADVAADJ0(r) ;
 DADVA.FX(r)         = DADVA0(r) ;

* Technology for factor activity and region specific factor efficiency

* ADFD.FX(f,a,r)       = ADFD0(f,a,r) ;
* ADFDfADJ.FX(f)      = ADFDfADJ0(f) ;
* ADFDaADJ.FX(a)      = ADFDaADJ0(a) ;
* ADFDrADJ.FX(r)      = ADFDrADJ0(r) ;

* Technology for factor activity and region specific factor efficiency

 ADFD.FX(ff,a,r)     = ADFD0(ff,a,r) ;
 
*## MISCELLANEOUS FIXED VARIABLES

* To use CPI as the numeraire fix CPI

 CPI.FX(r)            = CPI0(r)*numerchk ;

* To fix the real exchange rate fix ER and PPI

* PPI.FX(r)           = PPI0(r)*numerchk ;

* -------------- END OF anar_t Surplus Labour closure --------------------
