*--------------------- stg_t model description -------------------------
$ontext
* ------- DESCRIPTION OF BASIC MODEL -------------------------------------

The model is a c commodity, a activity, f factor, h household,
               e enterprise open economy model with 1 RoW account.

Versions of the model with
    i)   multiple trade partners
    ii)  nested energy inputs
    iii) nested factors of production
are available.

* ------- DATA -----------------------------------------------------------

The data are all, typically, stored in an Excel workbook as a series of
worksheets. The data may also be stored in GDX format, but this is relatively
rare.

  TRANSACTIONS DATA
The transaction data are stored as a SAM (worksheet 'SAM').
The model uses a SAM that has the following structure of potentially active
submatrices: X and Y mark submatrices active in the database and model
- submatrices marked X are strictly 0 to +inf while sumatrices
marked Y are bounded -inf to +inf.

         1      2      3       4       5      6     7      8      9
       COM   MARG  ACT   FACT  HHOLD  ENTP  GOVT  KAP   ROW
-------------------------------------------------------------
COM     0     X     X     0      X      0     X    Y     X
-------------------------------------------------------------
MARG    X     0     0     0      0      0     0    0     0
-------------------------------------------------------------
ACT     X     0     0     0      0      0     0    0     0
-------------------------------------------------------------
FACT    0     0     X     0      0      0     0    0     Y
-------------------------------------------------------------
HHOLD   0     0     0     X      Y      Y     Y    0     Y
-------------------------------------------------------------
ENTP    0     0     0     X      0      0     Y    0     0
-------------------------------------------------------------
GOVT    Y     0     Y     Y      Y      Y     0    0     Y
-------------------------------------------------------------
KAP     0     0     0     0      Y      Y     Y    0     Y
-------------------------------------------------------------
ROW     X     0     0     Y      0      0     0    0     0
-------------------------------------------------------------

  FACTOR USE DATA
The quantities of factors used by each activity are recorded in a
Factor Use matrix (worksheet 'FACTUSE'). If no factor use data are
available the model uses the transactions data from the SAM.

  UNEMPLOYMENT DATA
The rate of unemployment by each factor, as proportions, are recorded in a
matrix (f*1 dimensions) (worksheet 'ue_rate').

  ELASTCITIES DATA
The elasticities data are recorded in 5 worksheets.
   1. 'comelast': contains the elasticities relating to commodities (elastc)
   2. 'actelast': contains the elasticities relating to activities (elastx)
   3. 'elastf': contains the elasticities relating to nested factors (elastf)
   4. 'elasty': contains the income elasticities of demand by household (elasty)
   4. 'elastmu': contains the Frisch parameters by household (frischelast)
The default for these elasticities are deliberately uniform to avoid users
assuming the values are supported by empirical evidence.

* ------- SETS -----------------------------------------------------------

The sets are all, typically, stored in an Excel workbook as a series of
worksheets. The data may also be stored in GDX format, but this is very
rare. There are three worksheets of sets

   1. 'Sets': this worksheets records all the sets and subsets used in the
       model other than those set dynamically, i.e., using the data, those
       derived from the declared and assigned sets and mapping sets.
   2.  'Maps': this worksheet contains the mapping sets used in the model
       (mapping sets are used when members of pairs (or more) of sets need to
       be matched).
   3.  'res_sets': this worksheet contains a series of sets that are used when
       generating reports that describe the structure of the economy and
       the results from simulations (they are needed as part of the model
       so that structural tables can be generated BEFORE implementing
       experiments).

* #### TRADE MODELING

Trade is modelled using the Armington insight (Armington, 1969) under the
assumption that imperfect substitution between domestically produced and
imported goods is represented by a one-level CES function. In addition,
exports are assumed to be imperfect sbstitutes for domestically produced goods
and this is represented by a one-level CET function.

Small country assumption can be relaxed with Export Demand functions.

This model allows for non-traded and non-produced and non-consumed
domestic goods (ARMALT and CETALT).

* ## Imports
QQ is the quantity of a composite commodity, QM is the quantity of that
commodity imported, QD is the quantity of that commodity that is produced
and consumed domestically. CES indicates a CES function.

                                QQ
                             __/  \__
                          __/  CES   \__
                      __/               \__
                     /                      \
                    QM                      QD


* ## Exports
QXC is the quantity of a commodity produced domestically, QE is the quantity
of that commodity exported, QD is the quantity of that commodity that is
consumed domestically. CET indicates a CET function.

                                QXC
                             __/  \__
                          __/  CET   \__
                      __/               \__
                     /                      \
                    QE                      QD

* #### PRODUCTION STRUCTURE

This version uses a three-stage production structure. The top-level assumes CES
or Leontief technologies while the second-level assumes CES production
functions for aggregate value added and Leontief technology for aggregate
intermediate inputs; the same structure is assumed for all activities a. The
third-level assumes CES technology for the generation of aggregate factors,
e.g., aggregating types of labour to form aggregate labour. NB: the
third-level nest requires that the second-level nest can aggregate 'natural'
and aggreagte factors.

                                QX
                              _/  \_
                           _/CES/Leo \_
                        _/              \_
                      /                    \
                    QINT                  QVA
                    _/ \_                _/ | \_
                 _/  Leo \_            _/ CES  \_
               _/          \_        _/     |    \_
              /              \     /        |      \
           QINTD1         QINTD2  Land     Lab     Cap
                                          _/ | \_
                                        _/ CES  \_
                                      _/     |    \_
                                    /        |      \
                                   SLab           UsLab

(Leo indicates Leontief technologies, CES indicates CES function)
QX is the output of an activity, QINT is the aggregate intermediate input,
QINTD1 and QINTD2 are representative intermediate inputs, QVA is the aggregate
quantity of value addded, Lab is the aggregate quantity of labour and
SLab and UsLab are Skilled and Unskilled Labour, Land is land and
Cap is Capital.

* #### HOUSEHOLD UTILITY FUNCTION

Utility functions are CD or Stone Geary functions

* #### TAX INSTRUMENTS

The model has 11 different tax instruments; 7 on commodities, 2 on activities,
1 on factor incomes and 2 on incomes to institution.

   TAX INSTRUMENT                       LABEL             BASIS
 Export tax on comm'y c                 TE(c)             ad valorem
 Tariffs on comm'y c                    TM(c)             ad valorem
 Sales tax on comm'y c                  TS(c)             ad valorem
 Sales tax 2 on comm'y c                TSS(c)            ad valorem
 Excise tax on comm'y crate             TEX(c)            per unit quantity
 Value added tax on comm'y c            TV(c)             ad valorem
 Indirect tax rate on activ'y a         TX(a)             ad valorem
 Tax on factor use by activ'y a         TF(ff,a)          ad valorem
 Direct tax on factor income            TYF(f)            share of income
 Direct tax on households               TYH(h)            share of income
 Direct tax on enterprises              TYE(e)            share of income

$offtext

*--------------------- END of stg_t model description --------------------------
