*-------------------- stg_t model calibration -----------------------------
$ontext
   Calibration proceeds by reference to the blocks of equations
each block contains all the related parameter declarations and assignments
$offtext

* ------- NORMALISED PRICE BLOCK -----------------------------------------

PARAMETERS

 PD0(c)        Consumer price for domestic supply of commodity c
 PE0(c)        Domestic price of exports by commodity c
 PM0(c)        Domestic price of competitive imports c

 PX0(a)        Composite price of output by activity a
 PXC0(c)       Producer price of composite domestic output
 PXAC0(a,c)    Activity commodity prices

 PQS0(c)       Supply price of composite commodity c

 ER0           Exchange rate                         (domestic per world unit)

   ;

* #### Assignments

 PD0(c)      = 1 ;

 PM0(c)      = 1 ;
 PE0(c)      = 1 ;

* NOTE PX, PXC, PXAC and PQS are weighted averages of normalised prices hence

 PX0(a)      = 1 ;
 PXC0(c)     = 1 ;
 PXAC0(a,c)  = 1 ;

 PQS0(c)     = 1 ;

 ER0         = 1 ;

* ------- TRADE AND TRANSPORT TRANSACTIONS -------------------------------

SET
 dest  destinations for margins /
      domes
      expo  /
 ;

PARAMETER
 TTTRANS(m,c,dest)   Trade and transport margin transactions by destination

 TTTRANSCHK(m,c)     CHECK on TTTRANS

 totsupp(c)     total commodity supply at basic prices
 totdemd(c)     total commodity demand at purchaser prices

 QE02(c)        Domestic output exported by commodity c
 QD02(c)        Domestic demand for commodity c
 QM02(c)        Imports of commodity c
 QQ02(c)        Supply of composite commodity c

 ;

* ## Commodity quantities

*adding in and out import tax
 totsupp(c)         = SUM(a,SAM(a,c)) + SAM("row",c) + SAM("imptax",c) ;

 totdemd(c)         = SUM(sacn,SAM(sacn,c)) ;

 TTTRANS(m,c,"domes")  = SAM(m,c) ;

 TTTRANSCHK(m,c)    = SAM(m,c) - SUM(dest,TTTRANS(m,c,dest)) ;


* ------- TRADE BLOCK ----------------------------------------------------

* #### Exports Block

PARAMETERS

* ## Initial values for variables

 PWE0(c)       World price of exports in dollars

 QE0(c)        Domestic output exported by commodity c
 QD0(c)        Domestic demand for commodity c

* ## Parameters for CET functions

 at(c)          Shift parameter for Armington CET function
 gamma(c)       Share parameter for Armington CET function
 rhot(c)        Elasticity parameter for Output Armington CET function

* ## Parameters for Export Demand functions

 econ(c)        constant for export demand equations
 pwse(c)        world price of export substitutes
 eta(c)         export demand elasticity

  ;

* #### Assignments

* ## Initial values for variables

 QE0(c)      = (SAM(c,"row") - SAM("exptax",c)
                             - SUM(m,TTTRANS(m,c,"expo")))/PE0(c) ;

* Using {QXC0(c) = (SUM(a,SAM(a,c))/PXC0(c))} in statement for
* QD0(c) = QXC0(c) - QE0(c) ;

 QD0(c)      = (SUM(a,SAM(a,c))/PXC0(c)) - QE0(c) ;

 PWE0(c)$QE0(c)
              = (SAM(c,"row")/ER0)/QE0(c) ;

* ## Parameters for CET functions

 rhot(c)$(cd(c) AND ce(c))    = (1/ELASTC(c,"omega")) + 1 ;

 gamma(c)$(cd(c) AND ce(c))
              = 1/(1+PD0(c)/PE0(c)*(QE0(c)/QD0(c))**(rhot(c)-1));

* Using {QXC0(c) = (SUM(a,SAM(a,c))/PXC0(c))} in statement for at(c)

 at(c)$(cd(c) AND ce(c))
              = (SUM(a,SAM(a,c))/PXC0(c))
                 /(gamma(c)*QE0(c)**rhot(c) + (1-gamma(c))*
                       QD0(c)**rhot(c))**(1/rhot(c));

* ## Parameters for Export Demand functions

 econ(c)         = QE0(c) ;
 eta(c)          = ELASTC(c,"exdem") ;

 pwse(c)$QE0(c)  = PWE0(c) ;

* #### Imports Block

PARAMETERS

* ## Initial values for variables

 PWM0(c)       World price of imports in dollars

 QM0(c)        Imports of commodity c

 QQ0(c)        Supply of composite commodity c

* ## Parameters for Armington/CES functions

 ac(c)          Shift parameter for Armington CES function
 delta(c)       Share parameter for Armington CES function
 rhoc(c)        Elasticity parameter for Armington CES function

  ;

* #### Assignments


 QM0(c)      = (SAM("row",c) + SAM("imptax",c))/PM0(c) ;

 QQ0(c)      = QD0(c) + QM0(c) ;

 PWM0(c)$QM0(c)
              = (SAM("row",c)/ER0)/QM0(c) ;


* ## Parameters for Armington/CES functions

 rhoc(c)$(cx(c) AND cm(c))    = (1/ELASTC(c,"sigma")) - 1 ;

 delta(c)$(cd(c) AND cm(c))
               = (PM0(c)*QM0(c)**(rhoc(c)+1))
                  /(PM0(c)*QM0(c)**(rhoc(c)+1) + PD0(c)*QD0(c)**(rhoc(c)+1)) ;

 ac(c)$(cd(c) AND cm(c))
               = QQ0(c)/(delta(c)*QM0(c)**(-rhoc(c))
                         +(1-delta(c))*QD0(c)**(-rhoc(c)))**(-1/rhoc(c)) ;

* ------- TRADE AND TRANSPORT MARGINS BLOCK ------------------------------
PARAMETERS

* ## Initial values for variables
 PTT0(m)       Price of trade and transport margin m
 QTT0(m)       Quantity of trade and transport margin m
 QTTD0(c)      Intermediate input use for trade and transport margin m

* ## input output coefficients
 ioqttqq(m,c)  quantity of margin m used per unit of domestic demand QQ
 ioqttqe(m,c)  quantity of margin m used per unit of export demand QE
 ioqtdqtt(c,m) quantity of commodity c used to produce a unit of margin m

  ;

* #### Assignments

PARAMETER
 PQD02(c)       Purchaser price of composite commodity c

  ;

* NB: PQD0 not yet defined so using

 PQD02(c)  = 1.0 ;

 PQD02(c)$QQ0(c)
             = [SAM(c,"total") - SAM(c,"row") - SAM("vattax",c)]
                    /QQ0(c) ;

* ## Initial values for variables

 QTT0(m)$SUM(c,SAM(c,m))   = SUM[c,SAM(c,m)/PQD02(c)] ;

 PTT0(m)$(QTT0(m)) = SUM{c,[SAM(c,m)/PQD02(c)/QTT0(m)] * PQD02(c)} ;

 QTTD0(c)$(QQ0(c))
         = SUM(m,SAM(c,m)/{[SAM(c,"total") - SAM(c,"row")  - SAM("vattax",c)]
                          /QQ0(c)}) ;

* ## input output coefficients

 ioqttqq(m,c)$TTTRANS(m,c,"domes")
         = (TTTRANS(m,c,"domes")/PTT0(m))/QQ0(c) ;

 ioqttqe(m,c)$TTTRANS(m,c,"expo")
         = (TTTRANS(m,c,"expo")/PTT0(m))/QE0(c) ;

 ioqtdqtt(c,m)$SAM(c,m)
         = {SAM(c,m)/[(SAM(c,"total") - SAM(c,"row")  - SAM("vattax",c))
                     /QQ0(c)]}/QTT0(m) ;

* ------- COMMODITY PRICE BLOCK ------------------------------------------

PARAMETERS

* ## Initial values for variables

 PQD0(c)       Purchaser price of composite commodity c
 PQCD0(c)      Purchaser price of composite commodity c private final demand

  ;

* #### Assignments

* ## VAT rates for initialisation

Parameters
 tv2(c)         VAT rates for initialization
 ;

 tv2(c)$(SUM(h,SAM(c,h)) - SAM("vattax",c))
              = SAM("vattax",c)/(SUM(h, SAM(c,h)) - SAM("vattax",c)) ;

* ## Initial values for variables

 PQD0(c)$QQ0(c)
             = [SAM(c,"total") - SAM(c,"row") - SAM("vattax",c)]
                          /QQ0(c) ;

 PQCD0(c)    =  PQD0(c) * (1 + tv2(c)) ;

* ------- NUMERAIRE PRICE BLOCK ------------------------------------------

PARAMETERS

* ## Initial values for variables

 CPI0          Consumer price index
 PPI0          Producer (domestic) price index

* ## Price index weights

 comtotsh(c)    Share of commodity c in total commodity demand
 vddtotsh(c)    Share of value of domestic output for the domestic market

Parameter
 TESTFD(c)    test of FD after VAT ;

 TESTFD(c)   = (SUM(h,SAM(c,h)) - SAM("vattax",c)) ;

* ## Price index weights

* note that the CPI weights are based on household expenditure shares ONLY
* alternate 1 - CPI weights based on household final demand expenditure shares

 comtotsh(c)$(SUM((cp,hp),SAM(cp,hp)))
              = SUM(h,SAM(c,h))/(SUM((cp,hp),SAM(cp,hp))) ;

* alternate 2 - CPI weights based on total final demand expenditure shares
$ontext
 comtotsh(c)   = (SUM(h,SAM(c,h)) + SAM(c,"govt") + SAM(c,"kap"))
                 /(SUM((cp,hp),SAM(cp,hp))
                  + SUM(cp,SAM(cp,"govt"))
                  + SUM(cp,SAM(cp,"kap")))  ;
$offtext

* PPI weights are based on the value of domestic output for the domestic market

 vddtotsh(c)$(SUM((ap,cp),SAM(ap,cp)))
               = SUM(a,SAM(a,c))/SUM((ap,cp),SAM(ap,cp)) ;

* ## Initial values for variables

 CPI0         = SUM(c,comtotsh(c) * PQCD0(c) ) ;

 PPI0         = SUM(c,(SUM(a,SAM(a,c))/SUM((ap,cp),SAM(ap,cp)))*PD0(c)) ;

* ------- PRODUCTION BLOCK -----------------------------------------------

PARAMETERS

* ## Initial values for variables

 QX0(a)        Domestic production by activity a
 QXC0(c)       Domestic production by commodity c

 PVA0(a)       Value added price for activity a
 PINT0(a)      Price of aggregate intermediate input

 QINT0(a)      Aggregate quantity of intermediates used by activity a
 QVA0(a)       Quantity of aggregate value added for level 1 production

 QXAC0(a,c)    Domestic commodity output by each activity

 QINTD0(c,a)   Demand for intermediate inputs by commodity & activity

 WF0(ff)        Price of factor f
 WFDIST0(ff,a)  Sectoral proportion for factor prices
 WFA0(ff,a)     Price of factor f inclusive of Sectoral proportions
 
 V_FD0(ff,a)   Value of natural and aggregate factors used by activities

 FD0(ff,a)      Demand for factor f by activity a
 FSI0(insa,f)   Factor supplies from institution ins by factor f
 fsia(insa,f)   Factor supplies from institution ins by factor f for updating
 FS0(ff)        Supply of factor f

* Unemployment

 unemp_rate(f)  Unemployment rates
 UNEMP0(f)      Unemployed labor

* Technology Parameters and Adjustment factors

 ADX0(a)       Shift parameter for CES production functions for QX
 ADXADJ0       Scaling Factor for Shift parameter on CES functions for QX
 DADX0         Partial scaling factor for Shift parameter on CES functions for QX

 ADVA0(a)      Shift parameter for CES production functions for QVA
 ADVAADJ0      Scaling Factor for Shift parameter on CES functions for QVA
 DADVA0        Partial scaling factor for Shift parameter on CES functions for QVA

 ADFD0(ff,a)   Shift parameter for factor and activity specific efficiency

* CES aggregation functions for Level 1 of production nest

 adxb(a)        Shift parameter for CES production functions for QX
 dabadx(a)      Change in base shift parameter on functions for QX
 adx01(a)       0-1 par for flexing of shift parameter on functions for QX

 predeltax(a)   dummy used to estimated deltax
 deltax(a)      Share parameter for CES production functions for QX
 rhocx(a)       Elasticity parameter for CES production function for QX

* Leontief aggregation functions for Level 1 of production nest

 use(c,a)       use matrix transactions
 comactco(c,a)  use matrix coefficients

 ioqintqx(a)    Agg intermed quantity per unit QX for Level 1 Leontief agg
 ioqvaqx(a)     Agg value added quant per unit QX for Level 1 Leontief agg

* CES aggregation functions for Level 2 of production nest

 advab(a)       Shift parameter for CES production functions for QVA
 dabadva(a)     Change in base shift parameter on functions for QVA
 adva01(a)      0-1 par for flexing of shift parameter on functions for QVA

 deltava(ff,a)   Share parameters for CES production functions for QVA
 rhocva(a)      Elasticity parameter for CES production function for QVA
 
* CHECKS on deltava
 deltavaCHK(a)      check on deltava
 deltava_neg(ff,a)  CHECK that NO deltava are negative

 adfag(ff,a)       Shift parameter for factor and activity specific efficiency
 adfag0(ff,a)      Base Shift parameter for factor and activity specific efficiency
* ELASTF(ff,a)      Production elasticities indexed on aggregate factors
 rhofd(ff,a)       Elasticity parameter for CES prodn fns for Aggregated FD
 deltafd(ff,ff,a)  CES Share parameters for Aggregated FD fag using ff by a
 
* CHECKS on deltafd
 deltafdCHK(ff,a)     CHECK that all deltafd sum to ONE
 deltafd_neg(ff,ff,a) CHECK that NO deltafd are negative
 
* Reporting the nesting structure

 nest_va(ff,a)     Value added nest
 nest_fd(ff,ff,a)  All nests below VA

* Intermediate Input Demand

 ioqtdqd(c,a)   intermediate input output coefficients

* Commodity Output

 adxc(c)        Shift parameter for commodity output CES aggregation
 deltaxc(a,c)   Share parameters for commodity output CES aggregation
 rhocxc(c)      Elasticity parameter for commodity output CES aggregation

* Activity Output

 ioqxacqx(a,c)    Share of commodity c in output by activity a

 IOQXACQXV0(a,c)  Share of commodity c in output by activity a

* CET output functions
 ati(a)          Shift parameter for Armington CET function
 gammai(a,c)     Share parameter for Armington CET function per activity
 rhoti(a)        Elasticity parameter for Output Armington CET function

  ;

* #### Assignments

* Value of natural factors

 V_FD0(f,a)   = {SAM(f,a) + SUM[tff$map_f_tff(f,tff),SAM(tff,a)]} ;
 
* Value of aggregate factors

* V_FD0(fag,a) = SUM[ff$map_fagg_ff(fag,ff,a),SAM(ff,a)] ;

 V_FD0(fag,a) = SUM[ff$map_fagg_ff(fag,ff,a),V_FD0(ff,a)] ;
 
* ## Initial values for variables

 QX0(a)      = SAM("total",a)/PX0(a) ;
 QXC0(c)     = SUM(a,SAM(a,c))/PXC0(c) ;

 QINT0(a)$SUM(c,SAM(c,a))
             = SUM(c,SAM(c,a)/PQD0(c)) ;

 QVA0(a)     = SUM(f,SAM(f,a)) ;

 PINT0(a)$(QINT0(a))
              = SUM(c,(SAM(c,a)/PQD0(c)/QINT0(a)) * PQD0(c)) ;

 PVA0(a)$QVA0(a)
              = (SUM(f,SAM(f,a)) + SUM(tff,SAM(tff,a)) )/QVA0(a) ;

 QINTD0(c,a)$PQD0(c)    = SAM(c,a)/PQD0(c) ;

 FD0(f,a)     = FACTUSE(f,a) ;
 
 FSI0(insw,f) = FACTINS(insw,f) ;

* make one FSI0 residual - otherwise a problem may arise when FD.FX
* possibly due to the split fcap into fcap_fix and fcap_flex 

 FSI0('ent',f) = SUM(a, FD0(f,a)) - (SUM(h, FSI0(h,f)) + FSI0('row',f)) ;

* Adjustment to ensure accounting consistency between factor use and ownership
$ontext
 Ensure FSI0 and FD0 are consistent
NOTE
 Parameter FDTOT0(f)        total demand for a factor by activity
           FSI0_bsh(ins,f) base share for factor supply by institution ;

$offtext

 FDTOT0(f)   = SUM(a, FD0(f,a)) ;
 FSI0_bsh(insw,f)$(SUM(inswp, FSI0(inswp,f)))
             = FSI0(insw,f)/SUM(inswp, FSI0(inswp,f)) ;

* Redefine FSI0 using base shares to distribute total demand for the factor

 FSI0(insw,f)     = FSI0_bsh(insw,f)*FDTOT0(f) ;

 fsia(insw,f)     = FSI0(insw,f) ;

* Problem here if factor supply not consistent with factor demand

 FS0(f)     = SUM[insw, FSI0(insw,f)] ;

* End adjustment

* ## Initial values for variables
 QXAC0(a,c)  = SAM(a,c)/PXAC0(a,c) ;

 
* End adjustment

* Unemployment

 UNEMP0(f)    = 0.0 ;

$ontext
 Calibrate WF0 using the number working which now can be different
 than FS0, the number available to work
$offtext

$GDXIN 1_1_Model_data/data_in.gdx

$LOAD unemp_rate = ue_rate

$GDXIN

Set
 uef(f)       Unemployed factor ;

 uef(f)$(unemp_rate(f))       = YES ;

 UNEMP0(f)$uef(f)  = unemp_rate(f)*FS0(f) ;

* FS0(f)       = SUM(a,FACTUSE(f,a)) + UNEMP0(f) ;

*~~~~~ Factor prices for natural factors f

 WF0(f)$(FS0(f))
              = SUM(a,SAM(f,a))/FS0(f) ;

 WFDIST0(f,a)$FD0(f,a) = (SAM(f,a)/FD0(f,a))/WF0(f) ;
 WFDIST0(f,a)$(FD0(f,a) EQ 0) = 0.0 ;

 WFA0(f,a)$SAM(f,a)  = SAM(f,a)/FD0(f,a) ;

*~~~~~ Calibrating factor quantities and prices for aggregate factors

 FD0(fag,a)  = V_FD0(fag,a) ;

Parameter
 neg_FD0(ff,a)   Identify neg_FD0
 CHK_neg_FD0     CHECK on neg_FD0
  ;

 neg_FD0(ff,a)$(FD0(ff,a) LT 0.0) = FD0(ff,a) ;
 CHK_neg_FD0 = SUM[(ff,a)$neg_FD0(ff,a), 1 ] ;

Display neg_FD0, CHK_neg_FD0 ;

ABORT $(CHK_neg_FD0 GT 0.0)
  "At least ONE factor demand (FD0) is negative" ;

 FS0(fag)    = SUM[a,FD0(fag,a)] ;

 WF0(fag)$SUM[a, FD0(fag,a)]
             = SUM[a,V_FD0(fag,a)]/SUM[a, FD0(fag,a)] ;

* WF0(fag)$[FS0(fag)] = 1.0 ;

 WFA0(fag,a)$FD0(fag,a)
             = V_FD0(fag,a)/FD0(fag,a) ;

 WFDIST0(fag,a)$FD0(fag,a)
             = {V_FD0(fag,a)/FD0(fag,a)}/WF0(fag) ;

 WFDIST0(fag,a)$[FD0(fag,a) EQ 0] = 0.0 ;


* CES aggregation functions for Level 1 of production nest

 rhocx(a)    = (1/ELASTX(a,"sigmax")) - 1 ;

 deltax(a)$(QINT0(a))
               = (PVA0(a)*QVA0(a)**(1+rhocx(a)) )
                   /(PVA0(a)*QVA0(a)**(1+rhocx(a))
                      + PINT0(a)*QINT0(a)**(1+rhocx(a))) ;

 ADX0(a)$deltax(a)
               = QX0(a)/(deltax(a)*QVA0(a)**(-rhocx(a))
                      +(1-deltax(a))*QINT0(a)**(-rhocx(a)))**(-1/rhocx(a)) ;

 adxb(a)       = ADX0(a) ;
 dabadx(a)     = 0.0 ;
 adx01(a)      = 0.0 ;
 
* Technology Parameters and Adjustment factors

 ADXADJ0       = 1 ;
 DADX0         = 0 ;

 ADVAADJ0      = 1 ;
 DADVA0        = 0 ;

 ADFD0(ff,a)   = 1 ;
 
 adxb(a)       = ADX0(a) ;
 dabadx(a)     = 0.0 ;
 adx01(a)      = 0.0 ;
 
* Leontief aggregation functions for Level 1 of production nest

 use(c,a)$SAM("total",a)
               = SAM(c,a)/SAM("total",a) ;
 comactco(c,a)$(QX0(a)$PQD0(c))
               = (SAM(c,a)/PQD0(c))/QX0(a) ;

 ioqintqx(a)$QX0(a)   = QINT0(a)/QX0(a) ;

 ioqvaqx(a)$QX0(a)    = QVA0(a)/QX0(a) ;
 
* CES aggregation functions for Level 2 of production nest

Parameter
 tf02(ff,a)  tf for calibration of production functions
  ;

 tf02(f,a)$SAM(f,a)     = ((SUM(tff$map_f_tff(f,tff),SAM(tff,a)))
                                 /SAM(f,a)) ;
                                                                
* By construction factor use taxes are only paid on Natural factors see V_FD0 above

 tf02(fag,a)            = 0.0 ;

* share parameters WITH factor use taxes - tf02(f,a)

 rhocva(a)   = (1/ELASTX(a,"sigmava")) - 1 ;
 
* share parameters
 
 deltava(ff,a)$[map_va_ff(ff,a) AND FD0(ff,a)]
            = {[WF0(ff)*WFDIST0(ff,a)]*[1+tf02(ff,a)]*[FD0(ff,a)]**[1+rhocva(a)]}
              / SUM{ffp$map_va_ff(ffp,a),
                    [WF0(ff)*WFDIST0(ff,a)]*[1+tf02(ffp,a)]
                    *[FD0(ffp,a)]**[1+rhocva(a)]} ;
            
 deltavaCHK(a)  = [SUM(ff,deltava(ff,a))] - 1.0 ;

 deltavaCHK(a)$[ABS(deltavaCHK(a)) GT 0.0000000000000]   = 0.00 ;

 deltava_neg(ff,a)$[deltava(ff,a) LT 0.000]  = 1.00 ;

ABORT $(SUM[a,deltavaCHK(a)] NE 0.0)
 "SUM of ONE OR MORE deltava is not ONE - view deltava and deltavaCHK" ;

ABORT $(SUM[(ff,a),deltava_neg(ff,a)] NE 0.0)
 "ONE OR MORE deltava is negative - view deltava and deltava_neg" ;

 ADVA0(a)$SUM(ff$map_va_ff(ff,a),deltava(ff,a)*FD0(ff,a))
                   = QVA0(a)/(SUM(ff$map_va_ff(ff,a),deltava(ff,a)*FD0(ff,a)
                    **(-rhocva(a))))**(-1/rhocva(a));

 advab(a)      = ADVA0(a) ;
 dabadva(a)    = 0.0 ;
 adva01(a)     = 0.0 ; 

* CES aggregation functions for Level 3 of production nest

 rhofd(fag,a)   = (1/ELASTF(fag,a)) - 1 ;

Parameter

 test_deltafd(ff,a)  Denominator for deltafd calculation
;

 test_deltafd(ff,a) ={SUM(ffpp$map_fagg_ff(ff,ffpp,a),
                       [WF0(ffpp)*WFDIST0(ffpp,a)]*[1+tf02(ffpp,a)]*(FD0(ffpp,a))
                         **[1+rhofd(ff,a)])} ;

 deltafd(ff,ffp,a)${map_fagg_ff(ff,ffp,a) AND SUM[ffpp$map_fagg_ff(ff,ffpp,a), FD0(ffpp,a)] }
            = {[WF0(ffp)*WFDIST0(ffp,a)]*[1+tf02(ffp,a)]*(FD0(ffp,a))
                       **[1+rhofd(ff,a)]}
              /{SUM(ffpp$map_fagg_ff(ff,ffpp,a),
                  [WF0(ffpp)*WFDIST0(ffpp,a)]*[1+tf02(ffpp,a)]*(FD0(ffpp,a))
                       **[1+rhofd(ff,a)])} ;


 deltafdCHK(ff,a)$fag(ff)  = SUM(ffp$map_fagg_ff(ff,ffp,a),deltafd(ff,ffp,a)) - 1.0 ;

 deltafdCHK(ff,a)$[ABS(deltafdCHK(ff,a)) GT 0.0000000000000]   = 0.00 ;

 deltafd_neg(ff,ff,a)$[deltafd(ff,ff,a) LT 0.000]  = 1.00 ;

Option decimals = 8

Display deltafdCHK, deltafd_neg ;

ABORT $(SUM[(ff,a),deltafdCHK(ff,a)] NE 0.0)
 "SUM of ONE OR MORE deltafd is not ONE - view deltafd and deltafdCHK" ;

ABORT $(SUM[(ff,ffp,a),deltafd_neg(ff,ffp,a)] NE 0.0)
 "ONE OR MORE deltafd is negative - view deltafd and deltafd_neg" ;

* adfag(f,a) = 1 ;

 adfag(ff,a)${SUM[ffp,map_fagg_ff(ff,ffp,a)] AND SUM[ffp$map_fagg_ff(ff,ffp,a),FD0(ffp,a)]  }
                = FD0(ff,a)
                 /{ SUM[ffp$map_fagg_ff(ff,ffp,a),
                    deltafd(ff,ffp,a)*FD0(ffp,a)**(-rhofd(ff,a))] }
                    **[-1/rhofd(ff,a)] ;
                    
 adfag0(ff,a) = adfag(ff,a) ;
 
* Reporting the nesting structure

 nest_va(ff,a)$[deltava(ff,a) GT 0.0]    = 1.0 ;
 nest_fd(ff,ffp,a)$[deltafd(ff,ffp,a) GT 0.0]    = 1.0 ;


* Intermediate Input Demand

 ioqtdqd(c,a)$(QINT0(a)$PQD0(c))
               = SAM(c,a)/PQD0(c)/QINT0(a) ;
               
Parameter
 ioqtdqdCHK(a)     CHECK on sum of IO coefficients
 ;

 ioqtdqdCHK(a)    = SUM[c,ioqtdqd(c,a)] - 1.0 ;

 ioqtdqdCHK(a)$[ABS(ioqtdqdCHK(a)) GT 0.0000000000000]   = 0.00 ;

ABORT $(SUM[a,ioqtdqdCHK(a)] NE 0.0)
 "SUM of ONE OR MORE ioqtdqd is not ONE - view ioqtdqd and ioqtdqdCHK" ;

* Commodity Output

 rhocxc(c)   = (1/ELASTC(c,"sigmaxc")) - 1 ;

 deltaxc(a,c)$SAM(a,c)
               = (PXAC0(a,c)*QXAC0(a,c)**(1+rhocxc(c)))
                 /SUM(ap,PXAC0(ap,c)*QXAC0(ap,c)**(1+rhocxc(c))) ;

 adxc(c)$QXC0(c)
               = QXC0(c)/(SUM(a,deltaxc(a,c)*QXAC0(a,c)
                    **(-rhocxc(c)))**(-1/rhocxc(c))) ;

* Activity Output

* Activity Output
* parameter is defined in the data_load.inc file because it is used for set controls

 ioqxacqx(a,c)$SUM(cp,SAM(a,cp))
               = SAM(a,c)/SUM(cp,SAM(a,cp)) ;


 IOQXACQXV0(a,c)$QXAC0(a,c) =  QXAC0(a,c)/SUM(cp,QXAC0(a,cp)) ;

* CET output function parameter

 rhoti(a)$(acet(a))     = (1/ELASTX(a,"omegaout")) + 1 ;

 gammai(a,c)$(QXAC0(a,c)and acet(a))
                        = (PXAC0(a,c)*QXAC0(a,c)**(1-rhoti(a)) ) /
                             SUM(cp$QXAC0(a,cp), PXAC0(a,cp)*QXAC0(a,cp)
                                **(1-rhoti(a)) );

 ati(a)$(acet(a))     =  QX0(a)/SUM(c, gammai(a,c)*QXAC0(a,c)
                           **(rhoti(a)) )**(1/(rhoti(a))) ;

* ioqxacqx(a,c)$SUM(cp,SAM(a,cp))
*               = SAM(a,c)/SUM(cp,SAM(a,cp)) ;

* ------- FACTOR BLOCK ---------------------------------------------------

PARAMETERS

* ## Initial values for variables

 YF0(f)          Income to factor f
 YFDISP0(f)      Factor income for distribution after depreciation
 YFINS0(f)       Factor income distributed to domestic non govt institutions

 FSISH0(insa,f)  Shares of factor f supplied by institution insw
 INSVA0(insa,f)  Factor income after deprecn distribution to institn insw

* ## Savings Expenditures

 deprec(f)      accounting depreciation rate by factor f

* ## Transfer Expenditures

 hovash(h,f)    Share of income from factor f to household h
 entvash(e,f)   Share of income from factor f to enterprise e
 govvash(f)     Share of income from factor f to government
 worvash(f)     Share of income from factor f to RoW

 hovashchk(h,f)    Share of income from factor f to household h
 entvashchk(e,f)   Share of income from factor f to enterprise e
 govvashchk(f)     Share of income from factor f to government
 worvashchk(f)     Share of income from factor f to RoW

  ;

* #### Assignments

* ## Initial values for variables

 YF0(f)      = SAM("total",f) ;
 YFDISP0(f)  = (SAM("total",f) - SAM("i_s",f) - SAM("facttax",f)) ;

* YFINS0(f)   = YFDISP0(f) - SAM("govt",f) - SUM(w,SAM(w,f)) ;
 YFINS0(f)   = YFDISP0(f) ;

 FSISH0(insw,f)$SUM(inswp,FSI0(inswp,f))
             = FSI0(insw,f)/SUM(inswp,FSI0(inswp,f)) ;

Parameter
 FSISH0chk(f)   CHECK on FSISH0 ;

 FSISH0chk(f)  = SUM(insw,FSISH0(insw,f)) ;

 INSVA0(insw,f)    = FSISH0(insw,f) * YFINS0(f) ;

* ## Savings Expenditures

 deprec(f)$(SAM("total",f))
               = SAM("i_s",f)/SAM("total",f) ;

* ## Transfer Expenditures

 hovash(h,f)      = FSISH0(h,f) ;

 entvash(e,f)     = FSISH0(e,f) ;

 govvash(f)$YFDISP0(f)  = SAM("govt",f)/YFDISP0(f) ;

 worvash(f)$YFDISP0(f)  = SAM("row",f)/YFDISP0(f) ;

 hovashchk(h,f)$(YFDISP0(f))
                 = (SAM(h,f)/YFDISP0(f)) - hovash(h,f) ;

 entvashchk(e,f)$(YFDISP0(f))
                 = (SAM(e,f)/YFDISP0(f)) - entvash(e,f) ;

$ontext
 hovash(h,f)$(SAM("total",f) - SAM("i_s",f) - SAM("facttax",f))
                 = SAM(h,f)/
                    (SAM("total",f) - SAM("i_s",f) - SAM("facttax",f)) ;

 entvash(e,f)$(SAM("total",f) - SAM("i_s",f) - SAM("facttax",f))
                 = SAM(e,f)/
                    (SAM("total",f) - SAM("i_s",f) - SAM("facttax",f)) ;

 govvash(f)$(SAM("total",f) - SAM("i_s",f) - SAM("facttax",f))
                 = SAM("govt",f)/
                    (SAM("total",f) - SAM("i_s",f) - SAM("facttax",f)) ;

 worvash(f)$(SAM("total",f) - SAM("i_s",f) - SAM("facttax",f))
                 = SAM("row",f)/
                    (SAM("total",f) - SAM("i_s",f) - SAM("facttax",f)) ;
$offtext

* ------- HOUSEHOLD BLOCK ------------------------------------------------

PARAMETERS

* ## Initial values for variables

 YH0(h)         Income to household h
 YH_cap0(h)     Income per capita to household h
 YH_aeq0(h)     Income per capita adult equiv to household h
 HOHO0(h,hp)    Inter household transfer
 HEXP0(h)       Household consumption expenditure
 HEXP_cap0(h)   Household consumption expenditure per capita
 HEXP_aeq0(h)   Household consumption expenditure per capita adult equiv

 QCD0(c,h)      Household consumption by commodity c

* ## Transfer Expenditures

 hohosh(h,hp)   Share of h'hold h after tax and saving income transferred to hp

 hohoconst(h,hp) interhousehold transfers

 dirpay(h)      Agricultural support by direct payment to Agric households

* ## Consumption Expenditures
* # Cobb Douglas Utility function

 comhoav(c,h)   Household consumption shares
 alphah(c,h)    Expenditure share by commodity c for household h

* # Stone-Geary Utility function

 sumelast(h)    Weighted sum of income elasticities
 yhelast(c,h)   (Normalised) household income elasticities
 beta(c,h)      Marginal budget shares
 hexps(h)       Subsistence consumption expenditure
 frisch(h)      Elasticity of the marginal utility of income
 qcdconst(c,h)  Volume of subsistence consumption

  ;

* #### Assignments

* ## Initial values for variables

 YH0(h)          = SAM("total",h) ;

 YH_cap0(h)$popn(h,"pophh")       = YH0(h)/popn(h,"pophh") ;
 YH_aeq0(h)$popn(h,"pophaeq")     = YH0(h)/popn(h,"pophaeq") ;

 HOHO0(h,hp)     = SAM(h,hp) ;

 HEXP0(h)        = SUM(c,SAM(c,h)) ;

 HEXP_cap0(h)$popn(h,"pophh")    = HEXP0(h)/popn(h,"pophh") ;
 HEXP_aeq0(h)$popn(h,"pophaeq")  = HEXP0(h)/popn(h,"pophaeq") ;


 QCD0(c,h)$SAM(c,h) = SAM(c,h)/PQCD0(c) ;

* ## Transfer Expenditures

 hohosh(h,hp)$(SAM("total",h) - SAM("dirtax",h) - SAM("i_s",h))
                 = SAM(h,hp)/
                    (SAM("total",h) - SAM("dirtax",h) - SAM("i_s",h)) ;

 hohoconst(h,hp) = SAM(h,hp) ;

* ## Consumption Expenditures
* # Cobb Douglas Utility function

 comhoav(c,h)$SUM(cp,SAM(cp,h))
                 = SAM(c,h)/SUM(cp,SAM(cp,h)) ;

 alphah(c,h)$SUM(cp,SAM(cp,h))
                 = SAM(c,h)/(SUM(cp,SAM(cp,h))) ;

* # Stone-Geary Utility function
* Weighted sum of the expenditures elasticities must equal one.
* Weights are average budget shares. Normalised elasticities will satisfy
* Engel aggregation

 sumelast(h)   = SUM(c, alphah(c,h)*ELASTY(c,h)) ;

 yhelast(c,h)$sumelast(h)
               = ELASTY(c,h)/sumelast(h) ;

 yhelast(c,h)$(alphah(c,h) eq 0)  = 0 ;

 beta(c,h)     = yhelast(c,h)*alphah(c,h) ;

 frisch(h)     = ELASTMU(h,"frisc") ;

 qcdconst(c,h)$(PQCD0(c) and frisch(h) and beta(c,h))
               = [HEXP0(h)/PQCD0(c)]
                    *(alphah(c,h)+(beta(c,h)/frisch(h))) ;

 hexps(h)      = SUM(c,qcdconst(c,h) * PQCD0(c)) ;

Parameter
 betaCHK(h)      CHECK on beta
 hexpsCHK(h)     CHECK on hexps
 alphahCHK(h)    CHECK on sum of alphah ;

 betaCHK(h)    = SUM(c,beta(c,h)) ;

 alphahCHK(h)  = Sum[c, alphah(c,h)] ;

* ------- ENTERPRISE BLOCK -----------------------------------------------

PARAMETERS

* ## Initial values for scaling variables

 QEDADJ0       Enterprise demand volume Scaling Factor
 HEADJ0        Scaling factor for enterprise transfers to households

* ## Initial values for variables

 YE0(e)        Enterprise income

 HOENT0(h,e)   Household Income from enterprise e
 GOVENTSH0     Share of entp' income after tax save and consump to govt
 GOVENT0(e)    Government income from enterprise e

 QED0(c,e)     Enterprise consumption by commodity c
 VED0(e)       Value of enterprise consumption expenditure

* ## Transfer Expenditures

 hoentconst(h,e)  transfers to hhold h from enterprise e (nominal)
 hoentsh(h,e)   Share of entp' income after tax save and consump to h'hold
 goventsh(e)    Share of entp' income after tax save and consump to govt

* ## Consumption Expenditures

 qedconst(c,e) Enterprise demand volume

  ;

* #### Assignments

* ## Initial values for scaling variables

 QEDADJ0 = 1 ;
 HEADJ0    = 1 ;

* ## Initial values for variables

 YE0(e)      = SAM("total",e) ;

 HOENT0(h,e) = SAM(h,e) ;
 GOVENT0(e)  = SAM("govt",e) ;
 GOVENTSH0(e)$(SAM("total",e) - SAM("dirtax",e) - SAM("i_s",e) - SUM(c,SAM(c,e)))
             = SAM("govt",e)/
                (SAM("total",e) - SAM("dirtax",e)
                       - SAM("i_s",e) - SUM(c,SAM(c,e))) ;

 QED0(c,e) = SAM(c,e)/PQD0(c) ;
 VED0(e)   = SUM(c,SAM(c,e)) ;

* ## Transfer Expenditures

 hoentconst(h,e) = SAM(h,e)/CPI0 ;

 hoentsh(h,e)$(SAM("total",e) - SAM("dirtax",e) - SAM("i_s",e) - SUM(c,SAM(c,e)))
                 = SAM(h,e)/
                    (SAM("total",e) - SAM("dirtax",e)
                       - SAM("i_s",e) - SUM(c,SAM(c,e))) ;

 goventsh(e)$(SAM("total",e) - SAM("dirtax",e) - SAM("i_s",e) - SUM(c,SAM(c,e)))
                 = SAM("govt",e)/
                      (SAM("total",e) - SAM("dirtax",e)
                        - SAM("i_s",e) - SUM(c,SAM(c,e))) ;

* ## Consumption Expenditures

 qedconst(c,e)   = SAM(c,e)/PQD0(c) ;

* ------- GOVERNMENT BLOCK -----------------------------------------------

* #### Government Taxes Block

PARAMETERS
* ## Initial values for overall scaling variables

 TEADJ0        Export subsidy Scaling Factor
 TMADJ0        Import duty Scaling Factor
 TSADJ0        Sales tax rate scaling factor
 TSSADJ0       Sales tax 2 rate scaling factor
 TVADJ0        Value added tax rate scaling factor
 TEXADJ0       Excise tax rate scaling factor
 TXADJ0        Indirect Tax Scaling Factor
 TFADJ0        Factor Use Tax Scaling Factor
 TYFADJ0       Factor Tax Scaling Factor
 TYHADJ0       Household Income Tax Scaling Factor
 TYADJ0        Household and Enterprise Income Tax Scaling Factor
 TYEADJ0       Enterprise income tax Scaling Factor

* ## Initial values for partial scaling variables
 DTE0         Partial Export tax rate scaling factor
 DTM0         Partial Import tax rate scaling factor
 DTS0         Partial Sales tax rate scaling factor
 DTSS0        Partial Sales tax 2 rate scaling factor
 DTV0         Partial Value added tax rate scaling factor
 DTEX0        Partial Excise tax rate scaling factor
 DTX0         Partial Indirect tax rate scaling factor
 DTF0         Uniform adjustment to factor use tax by activity
 DTYF0        Partial direct tax on factor rate scaling factor
 DTYH0        Partial direct tax on household rate scaling factor
 DTY0         Partial direct tax on h'hold and enterprise rate scaling factor
 DTYE0        Partial direct tax on enterprise rate scaling factor

* ## Initial tax revenues
 MTAX0         Tariff revenue
 ETAX0         Export tax revenue
 VTAX0         Value added tax revenue
 STAX0         Sales tax revenue
 SSTAX0        Sales tax 2 revenue
 EXTAX0        Excise tax revenue
 ITAX0         Indirect tax revenue
 FTAX0         Factor use tax revenue
 FYTAX0        Factor Income tax revenue
 DTAX0         Direct Income tax revenue

* ## Initial tax rates
 TE0(c)        Export subsidy rate
 TM0(c)        Tariff rates
 TS0(c)        Sales tax rates
 TSS0(c)       Sales tax 2 rates
 TV0(c)        Value added tax rates
 TEX0(c)       Excise tax rates
 TYF0(f)       Factor Income tax rate
 TX0(a)        Indirect tax rate on activity a
 TF0(ff,a)     Factor use tax rate
 TYH0(h)       Direct tax rate on household h
 TYE0(e)       Direct tax rate on enterprises

* ## base tax rates
 teb(c)        Export subsidy rate
 tmb(c)        Tariff rate on commodity c
 tsb(c)        Sales tax rates
 tssb(c)       Sales tax 2 rates
 tvb(c)        Value added tax rates
 texb(c)       Excise tax rates
 tyfb(f)       Factor Income tax rate
 txb(a)        Indirect tax rate on activity a
 tfb(ff,a)     Factor use tax rate
 tyhb(h)       Direct tax rate on household h
 tyeb(e)       Direct tax rate on enterprises

* ## absolute changes in base tax rates

 dabte(c)      Change in base export taxes on comm'y imported from region w
 dabtm(c)      Change in base tariff rates on comm'y imported from region w
 dabts(c)      Change in base sales tax rate
 dabtss(c)     Change in base sales tax 2 rate
 dabtv(c)      Change in base value added tax rate
 dabtex(c)     Change in base excise tax rate
 dabtx(a)      Change in base indirect tax rate
 dabtf(ff,a)   Change in base factor us tax rate on activities
 dabtyf(f)     Change in base direct tax rate on factors
 dabtyh(h)     Change in base direct tax rate on households
 dabtye(e)     Change in base direct tax rate on enterprises

* ## partial changes in tax rates

 te01(c)       0-1 par for potential flexing of export taxes on comm'ies
 tm01(c)       0-1 par for potential flexing of Tariff rates on comm'ies
 ts01(c)       0-1 par for potential flexing of sales tax rates
 tss01(c)      0-1 par for potential flexing of sales tax 2 rates
 tv01(c)       0-1 par for potential flexing of value added tax rates
 tex01(c)      0-1 par for potential flexing of excise tax rates
 tx01(a)       0-1 par for potential flexing of indirect tax rates
 tf01(ff,a)    0-1 par for potential flexing of factor use tax rates
 tyf01(f)      0-1 par for potential flexing of direct tax rates on factors
 tyh01(h)      0-1 par for potential flexing of direct tax rates on h'holds
 tye01(e)      0-1 par for potential flexing of direct tax rates on e'rises

  ;

* #### Assignments

* ## Initial values for scaling variables

 TEADJ0       = 1.0 ;
 TMADJ0       = 1.0 ;
 TSADJ0       = 1.0 ;
 TSSADJ0      = 1.0 ;
 TVADJ0       = 1.0 ;
 TEXADJ0      = 1.0 ;
 TXADJ0       = 1.0 ;
 TFADJ0       = 1.0 ;
 TYFADJ0      = 1.0 ;
 TYHADJ0      = 1.0 ;
 TYADJ0       = 1.0 ;
 TYEADJ0      = 1.0 ;

* ## Initial values for partial scaling variables
 DTE0      = 0.0 ;
 DTM0      = 0.0 ;
 DTS0      = 0.0 ;
 DTSS0     = 0.0 ;
 DTV0      = 0.0 ;
 DTEX0     = 0.0 ;
 DTX0      = 0.0 ;
 DTF0      = 0.0 ;
 DTYF0     = 0.0 ;
 DTYH0     = 0.0 ;
 DTY0      = 0.0 ;
 DTYE0     = 0.0 ;

* ## Initial tax revenues

 ETAX0       = SUM(c,SAM("exptax",c)) ;
 MTAX0       = SUM(c,SAM("imptax",c)) ;
 STAX0       = SUM(c,SAM("saltax",c)) ;
 SSTAX0      = SUM(c,SAM("ssaltax",c)) ;
 VTAX0       = SUM(c,SAM("vattax",c)) ;
 EXTAX0      = SUM(c,SAM("ectax",c)) ;
 ITAX0       = SUM(a,SAM("indtax",a)) ;
 FTAX0       = SUM((f,a),SUM(tff$map_f_tff(f,tff),SAM(tff,a))) ;
 FYTAX0      = SUM(f,SAM("facttax",f)) ;
 DTAX0       = SUM(h,SAM("dirtax",h)) + SUM(e,SAM("dirtax",e)) ;

* ## Valuations at Basic and Purchaser Prices

Parameter
 Vdmd_PP(c)     Domestic absorption at purchaser prices
 Vdmd_BP(c)     Domestic absorption at basic prices
 ;

 Vdmd_PP(c)  = SUM(m,SAM(c,m)) + SUM(a,SAM(c,a)) + SUM(h,SAM(c,h))
              + SUM(e,SAM(c,e))+ SUM(g,SAM(c,g))
              + SUM(i,SAM(c,i)) + SAM(c,"dstoc") ;

 Vdmd_BP(c)  = Vdmd_PP(c)
                 - [SUM(m,SAM(m,c)) + SAM("saltax",c) + SAM("ssaltax",c)
                      + SAM("vattax",c) + SAM("ectax",c) ]   ;

* ## initial tax rates

 TM0(c)$cm(c) = SAM("imptax",c)/SAM("row",c) ;

 TE0(c)$ce(c) = SAM("exptax",c)/SAM(c,"row") ;

 TS0(c)$Vdmd_BP(c)
              = SAM("saltax",c)/Vdmd_BP(c) ;

 TSS0(c)$Vdmd_BP(c)
              = SAM("ssaltax",c)/Vdmd_BP(c) ;

 TEX0(c)$QQ0(c)
              = SAM("ectax",c)/QQ0(c) ;

 TV0(c)$(SUM(h,SAM(c,h)) - SAM("vattax",c))
             = SAM("vattax",c)/(SUM(h,SAM(c,h)) - SAM("vattax",c)) ;

Display TV0 ;

 TYF0(f)$(SAM("total",f) - SAM("i_s",f))
              = SAM("facttax",f)/(SAM("total",f) - SAM("i_s",f)) ;

 TX0(a)$SAM("total",a)
              = SAM("indtax",a)/SAM("total",a) ;

 TF0(f,a)$SAM(f,a)
              = SUM(tff$map_f_tff(f,tff),SAM(tff,a))/SAM(f,a) ;
              
 TF0(fag,a)   = 0.0 ;

 TYH0(h)$SAM("total",h)
              = SAM("dirtax",h)/SAM("total",h) ;

 TYE0(e)$SAM("total",e)
              = SAM("dirtax",e)/SAM("total",e) ;

* ## base tax rates
 teb(c)       = TE0(c) ;
 tmb(c)       = TM0(c) ;
 tsb(c)       = TS0(c) ;
 tssb(c)      = TSS0(c) ;
 tvb(c)       = TV0(c) ;
 texb(c)      = TEX0(c) ;
 tyfb(f)      = TYF0(f) ;
 txb(a)       = TX0(a) ;
 tfb(ff,a)    = TF0(ff,a) ;
 tyhb(h)      = TYH0(h) ;
 tyeb(e)      = TYE0(e) ;

* tmr(c)$cm(c) = tm0(c)*(c)*ER0 ;

* ## absolute changes in base tax rates

 dabte(c)     = 0.0 ;
 dabtm(c)     = 0.0 ;
 dabts(c)     = 0.0 ;
 dabtss(c)    = 0.0 ;
 dabtv(c)     = 0.0 ;
 dabtex(c)    = 0.0 ;
 dabtx(a)     = 0.0 ;
 dabtf(ff,a)  = 0.0 ;
 dabtyf(f)    = 0.0 ;
 dabtyh(h)    = 0.0 ;
 dabtye(e)    = 0.0 ;

* ## partial changes in tax rates

 te01(c)      = 0.0 ;
 tm01(c)      = 0.0 ;
 ts01(c)      = 0.0 ;
 tss01(c)     = 0.0 ;
 tv01(c)      = 0.0 ;
 tex01(c)     = 0.0 ;
 tx01(a)      = 0.0 ;
 tf01(ff,a)   = 0.0 ;
 tyf01(f)     = 0.0 ;
 tyh01(h)     = 0.0 ;
 tye01(e)     = 0.0 ;

* #### Government Income and Expenditure Block

PARAMETERS
* ## Initial values for scaling variables

 QGDADJ0       Government consumption demand scaling factor
 EGADJ0        Transfers to enterprises by government Scaling Factor
 HGADJ0        Scaling factor for government transfers to households

* ## Initial values for variables

 YG0           Government income

 QGD0(c)       Government consumption demand
 EG0           Expenditure by government
 VGD0          Value of Government consumption expenditure

* ## Transfer Expenditures

 hogovconst(h)  Transfers to hhold h from government (nominal but scalable)
 entgovconst(e) Government transfers to enterprise e

* ## Consumption Expenditures

 qgdconst(c)    Government demand volume

  ;

* #### Assignments

* ## Initial values for scaling variables

 QGDADJ0   = 1 ;
 EGADJ0    = 1 ;
 HGADJ0    = 1 ;

* ## Initial values for variables

 YG0         = SAM("total","govt") ;

 QGD0(c)     = SAM(c,"govt")/PQD0(c) ;
 EG0         = SAM("total","govt") - SAM("i_s","govt") ;
 VGD0        = SUM(c,SAM(c,"govt")) ;

* ## Transfer Expenditures

 hogovconst(h)   = SAM(h,"govt")/CPI0 ;

 entgovconst(e)  = SAM(e,"govt")/CPI0 ;

* ## Consumption Expenditures

 qgdconst(c)     = SAM(c,"govt")/PQD0(c) ;

* ------- KAPITAL BLOCK --------------------------------------------------

PARAMETERS
* ## Initial values for scaling variables

 SADJ0         Savings rate scaling factor for BOTH households and enterprises
 SHADJ0        Savings rate scaling factor for households
 SEADJ0        Savings rate scaling factor for enterprises
 IADJ0         Investment scaling factor

 DSHH0         Partial household savings rate scaling factor
 DS0           Partial household and enterprise savings rate scaling factor
 DSEN0         Partial enterprise savings rate scaling factor

* ## Initial values for variables

 QINVD0(c,i)   Investment consumption by commodity c
 QINV0(i)      Investment volume by investment type i

 INVSH_I0(i)   Shares of savings to investment of type i

 INVEST0       Total investment expenditure
 TOTSAV0       Total savings

 HHSAV0(h)     Initial HH savings
 ENTSAV0(e)    Initial Enterprise savings

* ## base and initial savings rates
 shh0(h)       Initial Household saving rates
 shhb(h)       Base Household saving rates

 sen0(e)       Initial Enterprise saving rates
 senb(e)       Base Enterprise saving rates

* ## absolute changes in base savings rates

 dabshh(h)     Change in base Household saving rates
 dabsen(e)     Change in base Enterprise saving rates

* ## partial changes in savings rates
 shh01(h)      0-1 par for potential flexing of Household saving rates
 sen01(e)      0-1 par for potential flexing of Enterprise saving rates

* ## Consumption Expenditures

 invconst(c,i)  Investment demand volume for investment of type i

 ioqinvd(c,i)   Input of commodity c per unit of investment of type i
 ioqinvdCHK(i)  Check on Input of commodity c per unit of investment of type i

 qinvb(i)       Investment volume by investment type i in base

 dstocconst(c)  Stock change demand volume

  ;

* #### Assignments

* ## Initial values for scaling variables

 SADJ0     = 1 ;
 SHADJ0    = 1 ;
 SEADJ0    = 1 ;
 IADJ0     = 1 ;

 DSHH0     = 0.0 ;
 DS0       = 0.0 ;
 DSEN0     = 0.0 ;

* ## Initial values for variables

 QINV0(i)$SUM(c,SAM(c,i))
              = SUM(c,SAM(c,i)/PQD0(c)) ;

 QINVD0(c,i)  = SAM(c,i)/PQD0(c) ;

* do not include dstoc in the denominator for the calculation of INVSH_IO

 INVSH_I0(i)   = SUM(c,PQD0(c)*QINVD0(c,i))
                                       /SUM((cp,ip),PQD0(cp)*QINVD0(cp,ip)) ;

 INVEST0      = SAM("TOTAL","i_s") ;

 TOTSAV0      = SAM("i_s","total") ;

 HHSAV0(h)    = SAM("i_s",h) ;

 ENTSAV0(e)   = SAM("i_s",e) ;

Parameter
 SAVCHK       CHECK on equality of Savings and Investmemts in data ;

 SAVCHK  = INVEST0 - TOTSAV0 ;

ABORT $(SAVCHK GT 0.0)
 "SAVINGS AND INVESTMENTS NOT EQUAL IN THE DATA", INVEST0, TOTSAV0, SAVCHK ;

* ## initial savings rates

 shh0(h)$(SAM("total",h) - SAM("dirtax",h))
              = SAM("i_s",h)/(SAM("total",h) - SAM("dirtax",h)) ;

 sen0(e)$(YE0(e) - SAM("dirtax",e))
              = SAM("i_s",e)/(YE0(e) - SAM("dirtax",e)) ;

* ## base savings rates

 shhb(h)      = shh0(h) ;
 senb(e)      = sen0(e) ;

* ## absolute changes in base savings rates

 dabshh(h)    = 0.0 ;
 dabsen(e)    = 0.0 ;

* ## partial changes in savings rates

 shh01(h)     = 0.0 ;
 sen01(e)     = 0.0 ;

* ## Consumption Expenditures

 invconst(c,i)   = SAM(c,i)/PQD0(c) ;

 dstocconst(c) = SAM(c,"dstoc")/PQD0(c) ;

 ioqinvd(c,i)$(QINV0(i)$PQD0(c))
                = SAM(c,i)/PQD0(c)/QINV0(i) ;

 ioqinvdCHK(i) = SUM(c,ioqinvd(c,i)) ;

 qinvb(i)       = QINV0(i) ;

* ------- FOREIGN INSTITUTIONS BLOCK -------------------------------------

PARAMETERS

* ## Initial values for variables

 YFWOR0(f)     Foreign factor income

* ## Savings Expenditures

* ## Transfer Expenditures

 factwor(f)     Factor payments from RoW (constant in foreign currency)
 howor(h)       Transfers to household from world (constant in foreign currency)
 entwor(e)      Transfers to enterprise e from world (constant in foreign currency)
 govwor         Transfers to government from world (constant in foreign currency)
  ;

* #### Assignments

* ## Initial values for variables

 YFWOR0(f)    = SAM("row",f) ;

* ## Transfer Expenditures

 factwor(f)   = SAM(f,"row")/ER0 ;

 howor(h)        = SAM(h,"row") ;

 entwor(e)       = SAM(e,"row") ;

 govwor          = SAM("govt","row")/ER0 ;

* ------- MARKET CLEARING BLOCK ------------------------------------------

PARAMETERS
* ## Initial values for variables

* # Account Closure

 KAPGOV0       Government Savings
 CAPWOR0       Current account balance

* # Absorption Closure

 VFDOMD0       Value of final domestic demand
 INVESTSH0     Value share of investment in total final domestic demand
 VGDSH0        Value share of Govt consumption in total final domestic demand
 VEDSH0(e)     Value share of Ent consumption in total final domestic demand

* ##### GDP

 GDP0          GDP from Expenditure
 ABSORP0       Absorption

* # Slack

 WALRAS0       Slack variable for Walras's Law

  ;

* #### Assignments

* ## Initial values for variables
* # Account Closure

 KAPGOV0     = SAM("i_s","govt") ;
 CAPWOR0     = SAM("i_s","row") ;

* # Absorption Closure

 VFDOMD0     = SUM((c,h),SAM(c,h))
                  + SUM((c,e),SAM(c,e))
                  + SUM(c,SAM(c,"govt"))
                  + SUM((c,in), SAM(c,in))
                  + SUM(c,SAM(c,"dstoc")) ;

 INVESTSH0$VFDOMD0
             = (SUM((c,in), SAM(c,in)) + SUM(c,SAM(c,"dstoc")))/VFDOMD0 ;

 VGDSH0$VFDOMD0
             = SUM(c,SAM(c,"govt"))/VFDOMD0 ;
 VEDSH0(e)$VFDOMD0
             = SUM(c,SAM(c,e))/VFDOMD0 ;

* ##### GDP

 GDP0      = SUM[(c,h),PQCD0(c) * QCD0(c,h)]
                  + SUM(c,PQD0(c)*QGD0(c))
                  + SUM[(c,in), PQD0(c)*QINVD0(c,in)]
                  + SUM(c,PQD0(c)*dstocconst(c))
                      + SUM(c, PWE0(c)*ER0*QE0(c))
                         - SUM(c, PWM0(c)*ER0*QM0(c)) ;

 ABSORP0   = SUM[(c,h),PQCD0(c) * QCD0(c,h)]
                  + SUM(c,PQD0(c)*QGD0(c))
                  + SUM[(c,in), PQD0(c)*QINVD0(c,in)]
                  + SUM(c,PQD0(c)*dstocconst(c)) ;


* # Slack

 WALRAS0   = 0.0 ;

*#### Various Checks on Calibration

$INCLUDE 2_include/stg_t_calibchk.inc


*-------------------- END of stg_t model calibration ----------------------
* KT TEST
 Parameter YE02(e) recalculated from model equation
           YE_INSVA0(e)   ;

 YE02(e) =  SUM(f,INSVA0(e,f))
                             + (EGADJ0 * entgovconst(e) * CPI0)
                             + (entwor(e)*ER0) ;
 YE_INSVA0(e)  = SUM(f,INSVA0(e,f))   ;

display YE02, YE0, YE_INSVA0, INSVA0;
