* -------------------- stg_t experiment file -----------------------------
$ontext
 This file sets up and runs experiments on a model. It has a standard structure
 which is described directly below, but makes use (in sections 1 and 7) of two
 include files where users can define and implement their experiments.

 Structure (indentation indicates code structure):
   1.  Declare and Assign Simulation Set
   2.  Declare and Assign experiment parameters
   |   2a. Declare experiment parameters
   |   2b. Assign experiment parameters
   3.  Declare Result parameters
   4.  Setting Closures
   |   4a. Declaring Parameters for Closure
   |   4b. Assigning Parameters for Closure
   |   4c. Implementing Closure Changes
   5.  sim loop begins
   6.  Shocks implemented
   7.  Solve statement
   8.  Storing results
   9.  Terminating sim and expclos loops


The experiment code consists of a number of files; the relationships between
these files is illustrated below.

 stg_t.gms                                master programme file
     |
    .
     .
      .
       .
     |
     | 16. POLICY EXPERIMENTS
     |
     |<----- stg_t_expt_***.inc                 Experiment files
                 |
                 |<----- stg_t_resparm.inc       Declare results params
                 |
                 |<----- stg_t_varinit2.inc      Reinitialise variables
                 |<----- stg_t_reset.inc         Reset closure variables
                 |
                 |<----- stg_t_cl***1.inc        Alternative closures
                 |<----- stg_t_cl***..inc                 .
                 |<----- stg_t_cl***..inc                 .
                 |<----- stg_t_cl***n.inc        Alternative closures
                 |
                 |
                 |<----- stg_t_resassign.inc     Assigning results params
                 |
                 |
                 
      |
      |<----- stg_t_anal.inc                 Result Analyses sub routine
      |          |
                 |
                 |<----- stg_t_reslevel.inc       Levels results saved
                 |
                 |<----- stg_t_resmacro.inc       Macroeconomic results
                 |
                 |<----- stg_t_reswelf.inc        Welfare results
                 |
                 |<----- stg_t_resstruct.inc      Structural results
                 |
                 |<----- stg_t_resindex.inc       Price index results
                 |
                 |<----- stg_t_resperc.inc        Proportionate results

$offtext

* ------- 1. Declare and Assign Simulation Set ---------------------------

* By including a "base case" in the SIM set a comparator is produced

SETS
* Sets for simulations
 sim          simulations
 simc(sim)    simulations currently run

* Sets for closures
 clos         Set of sets of closure rules for each experiment

 elst         elasticities

* Sets to control experiment flows
 econs        set for parameters controlling experiment & analyses

* Sets for results
 adjres       adjuster results
 scalres      scalar results

  ;

Parameter
* Parameters used to control experiment & analyses

 exp_cont(econs)    values for parameters controlling model content

*---- 1a. Excel workbook sets and data converted to gdx here

$CALL "GDXXRW i=1_2_Expt_data\%expt_data%.xlsx o=1_2_Expt_data\expt_in.gdx index=Layout!A4"

$if errorLevel 1 $abort problems with GDXXRW

*---- 1b. Load sets from GDX data file

$GDXIN 1_2_Expt_data\expt_in.gdx

* Sets to control simulations
$LOADdc sim simc

* Sets to control closure rule selection
$LOADdc clos

* Sets to control experiment flows
$LOAD econs exp_cont

$GDXIN

DISPLAY sim, simc, clos, exp_cont, econs, adjres, scalres ;

* ------- 2. Declare and Assign experiment parameters -------------------

*---- 2a. Declare experiment parameters

Parameter
 tmsim(c,sim)    tariff rate shock
  ;

* --- 2b. Assign experiment parameters

 tmsim(c,"base") = 0.00 * tm0(c) ;
 tmsim(c,"sim01") = -0.5 * tm0(c) ;

Display tmsim ;


* ------- 3. Declare Result parameters ----------------------------------

$INCLUDE 5_analysis\stg_t_resparm.inc

* ------- 4. Setting Closures ------------------------------------------------
* ---- 4a. Declaring Parameters for Closure

Parameter

 closure(clos)    values that control choice of closure

  ;

* --- 4b. Assigning Parameters for Closure ----------------------------

* --- 4c. Implementing Closure Changes --------------------------------

* ------- 5. sim loop begins ---------------------------------------------

LOOP(simc(sim),

* ------- 6. Shocks implemented ------------------------------------------

* ... SHOCKS HERE ...

 dabtm(c)  = tmsim(c,simc) ;


* ------- 7. Solve statement ---------------------------------------------

 OPTION DECIMALS = 6 ;
 option MCP        = PATH ;

 stg_t.HOLDFIXED   = 1 ;
 stg_t.TOLINFREP   = 0.0000001 ;
 stg_t.TOLINFEAS   = 0.000000001 ;

 Solve stg_t Using MCP ;

* ------- 8. Storing results ---------------------------------------------

$INCLUDE 5_analysis\stg_t_resassign.inc

* ------- 9. Terminating sim and expclos loops ---------------------------

* The following two lines terminate the experiment loops

 ) ;
 
* ------------------ END of stg_t experiment file ------------------------
